/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.adcs.proxy.config;

import de.trustable.ca3s.adcs.proxy.config.APIKeyAuthFilter;
import de.trustable.ca3s.adcs.proxy.config.ApiKeyAuthenticationManager;
import de.trustable.ca3s.adcs.proxy.security.jwt.JWTConfigurer;
import de.trustable.ca3s.adcs.proxy.security.jwt.TokenProvider;
import de.trustable.ca3s.adcs.proxy.service.JWSService;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Import;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.header.writers.ReferrerPolicyHeaderWriter;
import org.zalando.problem.spring.web.advice.security.SecurityProblemSupport;
import tech.jhipster.config.JHipsterProperties;

@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
@Import(value={SecurityProblemSupport.class})
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private final JHipsterProperties jHipsterProperties;
    private static final Logger log = LoggerFactory.getLogger(SecurityConfiguration.class);
    @Value(value="${adcs-proxy.connection.api-key-header-name:X-API-Key}")
    private String principalRequestHeader;
    @Value(value="${adcs-proxy.connection.use-api-key:false}")
    private String useApiKey;
    @Autowired
    private JWSService jwsService;
    private final TokenProvider tokenProvider;
    private final SecurityProblemSupport problemSupport;

    public SecurityConfiguration(TokenProvider tokenProvider, JHipsterProperties jHipsterProperties, SecurityProblemSupport problemSupport) {
        this.tokenProvider = tokenProvider;
        this.problemSupport = problemSupport;
        this.jHipsterProperties = jHipsterProperties;
    }

    public void configure(HttpSecurity http) throws Exception {
        APIKeyAuthFilter filter = new APIKeyAuthFilter(this.principalRequestHeader);
        ApiKeyAuthenticationManager authManager = new ApiKeyAuthenticationManager(this.jwsService.getAPIKey());
        filter.setAuthenticationManager((AuthenticationManager)authManager);
        JWTConfigurer config = (JWTConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.problemSupport).accessDeniedHandler((AccessDeniedHandler)this.problemSupport).and()).headers().contentSecurityPolicy(this.jHipsterProperties.getSecurity().getContentSecurityPolicy()).and().referrerPolicy(ReferrerPolicyHeaderWriter.ReferrerPolicy.STRICT_ORIGIN_WHEN_CROSS_ORIGIN).and().featurePolicy("geolocation 'none'; midi 'none'; sync-xhr 'none'; microphone 'none'; camera 'none'; magnetometer 'none'; gyroscope 'none'; fullscreen 'self'; payment 'none'").and().frameOptions().deny().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(new String[]{"/api/authenticate"})).permitAll().antMatchers(new String[]{"/api/admin/**"})).hasAuthority("ROLE_ADMIN").antMatchers(new String[]{"/api/**"})).authenticated().antMatchers(new String[]{"/management/health"})).permitAll().antMatchers(new String[]{"/management/health/**"})).permitAll().antMatchers(new String[]{"/management/info"})).permitAll().antMatchers(new String[]{"/management/prometheus"})).permitAll().antMatchers(new String[]{"/management/**"})).hasAuthority("ROLE_ADMIN").and()).apply((SecurityConfigurerAdapter)this.securityConfigurerAdapter());
        if (Boolean.parseBoolean(this.useApiKey)) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)config.and()).addFilter((Filter)filter).authorizeRequests().anyRequest()).authenticated();
            log.info("api-key required on every call");
        }
    }

    private JWTConfigurer securityConfigurerAdapter() {
        return new JWTConfigurer(this.tokenProvider);
    }
}

