/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.adcs.proxy;

import de.trustable.ca3s.adcs.proxy.config.ApplicationProperties;
import de.trustable.ca3s.adcsKeyStore.provider.LocalADCSBundleFactory;
import de.trustable.ca3s.adcsKeyStore.provider.LocalADCSKeyManagerProvider;
import de.trustable.ca3s.adcsKeyStore.provider.LocalADCSProvider;
import de.trustable.ca3s.adcsKeyStore.provider.PropertyProvider;
import de.trustable.ca3s.adcsKeyStore.provider.SpringEnvironmentPropertyProviderImpl;
import de.trustable.ca3s.cert.bundle.BundleFactory;
import de.trustable.ca3s.cert.bundle.TimedRenewalCertMap;
import de.trustable.util.JCAManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import tech.jhipster.config.DefaultProfileUtil;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
@EnableConfigurationProperties(value={ApplicationProperties.class})
public class AdcsProxyApp
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AdcsProxyApp.class);
    private final Environment env;

    public AdcsProxyApp(Environment env) {
        this.env = env;
    }

    @PostConstruct
    public void initApplication() {
        List<String> activeProfiles = Arrays.asList(this.env.getActiveProfiles());
        if (activeProfiles.contains("dev") && activeProfiles.contains("prod")) {
            log.error("You have misconfigured your application! It should not run with both the 'dev' and 'prod' profiles at the same time.");
        }
        if (activeProfiles.contains("dev") && activeProfiles.contains("cloud")) {
            log.error("You have misconfigured your application! It should not run with both the 'dev' and 'cloud' profiles at the same time.");
        }
    }

    public void afterPropertiesSet() {
        this.initApplication();
    }

    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(new Class[]{AdcsProxyApp.class});
        DefaultProfileUtil.addDefaultProfile((SpringApplication)app);
        ConfigurableEnvironment env = app.run(args).getEnvironment();
        AdcsProxyApp.logApplicationStartup((Environment)env);
    }

    private static void logApplicationStartup(Environment env) {
        String protocol = Optional.ofNullable(env.getProperty("server.ssl.key-store")).map(key -> "https").orElse("http");
        String serverPort = env.getProperty("server.port");
        String contextPath = Optional.ofNullable(env.getProperty("server.servlet.context-path")).filter(StringUtils::isNotBlank).orElse("/");
        String hostAddress = "localhost";
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.warn("The host name could not be determined, using `localhost` as fallback");
        }
        log.info("\n----------------------------------------------------------\n\tApplication '{}' is running! Access URLs:\n\tLocal: \t\t{}://localhost:{}{}\n\tExternal: \t{}://{}:{}{}\n\tProfile(s): \t{}\n----------------------------------------------------------", new Object[]{env.getProperty("spring.application.name"), protocol, serverPort, contextPath, protocol, hostAddress, serverPort, contextPath, env.getActiveProfiles()});
    }

    @Bean
    public TimedRenewalCertMap timedRenewalCertMap() {
        log.debug("in timedRenewalCertMap()");
        JCAManager.getInstance();
        SpringEnvironmentPropertyProviderImpl propProvider = new SpringEnvironmentPropertyProviderImpl(this.env);
        return new TimedRenewalCertMap((BundleFactory)new LocalADCSBundleFactory((PropertyProvider)propProvider));
    }

    @Bean
    @DependsOn(value={"timedRenewalCertMap"})
    public LocalADCSKeyManagerProvider localADCSKeyManagerProvider() {
        log.debug("in localADCSKeyManagerProvider()");
        LocalADCSKeyManagerProvider localADCSKeyManagerProvider = new LocalADCSKeyManagerProvider(this.timedRenewalCertMap());
        Security.addProvider((Provider)localADCSKeyManagerProvider);
        return localADCSKeyManagerProvider;
    }

    @Bean
    @DependsOn(value={"timedRenewalCertMap"})
    public LocalADCSProvider localADCSProvider() {
        log.debug("in localADCSProvider()");
        SpringEnvironmentPropertyProviderImpl propProvider = new SpringEnvironmentPropertyProviderImpl(this.env);
        LocalADCSProvider localADCSProvider = new LocalADCSProvider(this.timedRenewalCertMap(), propProvider);
        Security.addProvider((Provider)localADCSProvider);
        return localADCSProvider;
    }

    @Bean
    @DependsOn(value={"localADCSKeyManagerProvider", "localADCSProvider"})
    public UndertowServletWebServerFactory embeddedServletContainerFactory() {
        log.info("\n----------------------------------------------------------\n\t configure Undertow for TLS\n----------------------------------------------------------\n\t");
        UndertowServletWebServerFactory factory = new UndertowServletWebServerFactory();
        factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{new /* Unavailable Anonymous Inner Class!! */});
        return factory;
    }
}

