/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.challenge;

import de.trustable.ca3s.challenge.exception.ChallengeDNSException;
import de.trustable.ca3s.challenge.exception.ChallengeDNSIdentifierException;
import de.trustable.ca3s.challenge.exception.ChallengeUnknownHostException;
import de.trustable.ca3s.challenge.exception.ChallengeValidationFailedException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.bouncycastle.asn1.ASN1OctetString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;

public class ChallengeValidator {
    transient Logger LOG = LoggerFactory.getLogger(ChallengeValidator.class);
    public static final String ACME_CHALLENGE_PREFIX_STRING = "_acme-challenge";
    public static final Name ACME_CHALLENGE_PREFIX = Name.fromConstantString((String)"_acme-challenge");
    public static final String ACME_VALIDATION_OID = "1.3.6.1.5.5.7.1.31";
    public static final String ACME_TLS_1_PROTOCOL = "acme-tls/1";
    private final int[] ports;
    private final int[] httpsPorts;
    private final long timeoutMilliSec;
    private boolean dnsActive;
    private SimpleResolver dnsResolver;

    public ChallengeValidator(String resolverHost, int resolverPort, long timeoutMilliSec, int[] ports, int[] httpsPorts) {
        if (resolverHost == null || resolverHost.isEmpty()) {
            this.dnsActive = false;
            this.dnsResolver = null;
        } else {
            try {
                this.dnsResolver = new SimpleResolver(resolverHost);
                this.dnsResolver.setPort(resolverPort);
                this.LOG.info("Applying default DNS resolver {}", (Object)this.dnsResolver.getAddress());
                this.dnsActive = true;
            }
            catch (UnknownHostException e) {
                this.dnsActive = false;
                this.LOG.info("Intialization of DNS resolver at '" + resolverHost + "':" + resolverPort + " failed!");
            }
        }
        this.timeoutMilliSec = timeoutMilliSec;
        this.ports = ports == null || ports.length == 0 ? new int[]{80, 5544, 8800} : ports;
        this.httpsPorts = httpsPorts == null || httpsPorts.length == 0 ? new int[]{443, 8443} : httpsPorts;
    }

    public Collection<String> retrieveChallengeDNS(String identifierValue) throws ChallengeDNSIdentifierException, ChallengeDNSException {
        Name nameToLookup;
        try {
            Name nameOfIdentifier = Name.fromString((String)identifierValue, (Name)Name.root);
            this.LOG.info("DNS TXT lookup for identifier '" + identifierValue + "'");
            nameToLookup = Name.concatenate((Name)ACME_CHALLENGE_PREFIX, (Name)nameOfIdentifier);
        }
        catch (NameTooLongException | TextParseException e) {
            String msg = "problem while DNS lookup of identifier '" + identifierValue + "'";
            throw new ChallengeDNSIdentifierException(msg);
        }
        Lookup lookupOperation = new Lookup(nameToLookup, 16);
        lookupOperation.setResolver((Resolver)this.dnsResolver);
        lookupOperation.setCache(null);
        this.LOG.info("DNS lookup: {} records of '{}' (via resolver '{}')", new Object[]{Type.string((int)16), nameToLookup, this.dnsResolver.getAddress()});
        Instant startedAt = Instant.now();
        Object[] lookupResult = lookupOperation.run();
        this.LOG.info("lookupOperation result {}, error: {}", (Object)lookupOperation.getResult(), (Object)lookupOperation.getErrorString());
        switch (lookupOperation.getResult()) {
            case 0: {
                break;
            }
            case 4: {
                return Collections.EMPTY_LIST;
            }
            case 3: {
                throw new ChallengeDNSException("Problem accessing DNS resolver: HOST_NOT_FOUND");
            }
            case 2: {
                throw new ChallengeDNSException("Problem accessing DNS resolver: TRY_AGAIN");
            }
            case 1: {
                throw new ChallengeDNSException("Problem accessing DNS resolver: UNRECOVERABLE");
            }
            default: {
                String msg = "Unexpected DNS lookup result: " + lookupOperation.getResult();
                this.LOG.warn(msg);
                throw new ChallengeDNSException("Problem accessing DNS resolver: UNRECOVERABLE");
            }
        }
        Duration lookupDuration = Duration.between(startedAt, Instant.now());
        this.LOG.info("DNS lookup yields: {} (took {})", (Object)Arrays.toString(lookupResult), (Object)lookupDuration);
        return this.extractTokenFrom((Record[])lookupResult);
    }

    public String retrieveChallengeHttp(String host, String token) throws ChallengeUnknownHostException, ChallengeValidationFailedException {
        String fileNamePath = "/.well-known/acme-challenge/" + token;
        for (int port : this.ports) {
            String msg;
            try {
                URL url = new URL("http", host, port, fileNamePath);
                this.LOG.debug("Opening connection to  : " + url);
                CloseableHttpClient instance = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
                HttpGet request = new HttpGet(url.toString());
                request.addHeader("User-Agent", "CA3S_ACME");
                RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout((int)this.timeoutMilliSec).setConnectTimeout((int)this.timeoutMilliSec).setSocketTimeout((int)this.timeoutMilliSec).build();
                request.setConfig(requestConfig);
                HttpResponse response = instance.execute((HttpUriRequest)request);
                int responseCode = response.getStatusLine().getStatusCode();
                this.LOG.debug("\nSending 'GET' request to URL : " + url);
                this.LOG.debug("Response Code : " + responseCode);
                if (responseCode == 200) {
                    String actualContent = this.readChallengeResponse(response.getEntity().getContent());
                    return actualContent;
                }
                String msg2 = "read challenge responded with unexpected code : " + responseCode;
                this.LOG.info(msg2);
            }
            catch (UnknownHostException uhe) {
                msg = "unable to resolve hostname: '" + host + "' checking HTTP-01 challenge.";
                this.LOG.info(msg);
                throw new ChallengeUnknownHostException(msg);
            }
            catch (SocketTimeoutException | ConnectTimeoutException ste) {
                msg = "timeout connecting to " + host + ":" + port + "  checking HTTP-01 challenge!";
                this.LOG.info(msg);
            }
            catch (IOException ioe) {
                msg = "problem reading HTTP-01 challenge response on " + host + ":" + port + " : " + ioe.getMessage();
                this.LOG.info(msg);
                this.LOG.debug("exception occurred reading challenge response", (Throwable)ioe);
            }
        }
        throw new ChallengeValidationFailedException();
    }

    private String readChallengeResponse(HttpURLConnection con) throws IOException {
        return this.readChallengeResponse(con.getInputStream());
    }

    private String readChallengeResponse(InputStream is) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
            if (response.length() <= 1000) continue;
            this.LOG.debug("limiting read of challenge response to 1000 characters.");
            break;
        }
        in.close();
        String actualContent = response.toString().trim();
        if (actualContent.length() > 100) {
            this.LOG.debug("read challenge response (truncated): " + actualContent.substring(0, 100) + " ...");
        } else {
            this.LOG.debug("read challenge response: " + actualContent);
        }
        return actualContent;
    }

    public String retrieveChallengeALPN(String host) throws GeneralSecurityException, ChallengeUnknownHostException, ChallengeValidationFailedException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        for (int port : this.httpsPorts) {
            String msg;
            try {
                return this.validateALPNChallenge(host, trustAllCerts, port);
            }
            catch (UnknownHostException uhe) {
                msg = "unable to resolve hostname: '" + host + "'";
                this.LOG.info(msg);
                throw new ChallengeUnknownHostException(msg);
            }
            catch (IOException ioe) {
                msg = "problem reading alpn certificate on " + host + ":" + port + " : " + ioe.getMessage();
                this.LOG.info(msg);
                this.LOG.debug("exception occurred reading challenge response", (Throwable)ioe);
            }
            catch (CertificateException ce) {
                msg = "problem reading alpn challenge response in certificate provided by " + host + ":" + port + " : " + ce.getMessage();
                this.LOG.info(msg);
                this.LOG.debug("exception occurred reading alpn challenge response certificate", (Throwable)ce);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new GeneralSecurityException(e);
            }
        }
        throw new ChallengeValidationFailedException();
    }

    private String validateALPNChallenge(String host, TrustManager[] trustAllCerts, int port) throws IOException, CertificateException, NoSuchAlgorithmException, KeyManagementException {
        String msg;
        Certificate[] serverCerts;
        this.LOG.debug("Opening ALPN connection to {}:{} ", (Object)host, (Object)port);
        try (Socket sslSocket = null;){
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslsf = sslContext.getSocketFactory();
            sslSocket = (SSLSocket)sslsf.createSocket(host, port);
            SSLParameters sslp = ((SSLSocket)sslSocket).getSSLParameters();
            SNIHostName serverName = new SNIHostName(host);
            sslp.setServerNames(Collections.singletonList(serverName));
            String[] clientAPs = new String[]{ACME_TLS_1_PROTOCOL};
            sslp.setApplicationProtocols(clientAPs);
            ((SSLSocket)sslSocket).setSSLParameters(sslp);
            ((SSLSocket)sslSocket).startHandshake();
            String ap = ((SSLSocket)sslSocket).getApplicationProtocol();
            this.LOG.debug("Application Protocol server side: \"" + ap + "\"");
            serverCerts = ((SSLSocket)sslSocket).getSession().getPeerCertificates();
        }
        if (serverCerts.length == 0) {
            msg = "no certificate available after connection with " + host + ":" + port;
            this.LOG.info(msg);
            throw new CertificateException(msg);
        }
        if (serverCerts.length > 1) {
            msg = "more than one (#" + serverCerts.length + ") certificate returned " + host + ":" + port + ", expecting a single selfsigned certificate";
            this.LOG.info(msg);
            throw new CertificateException(msg);
        }
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(serverCerts[0].getEncoded());
        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(in);
        this.validateALPNCertificate(host, port, cert);
        byte[] acmeValidationExtBytes = cert.getExtensionValue(ACME_VALIDATION_OID);
        ASN1OctetString octetString = (ASN1OctetString)ASN1OctetString.fromByteArray((byte[])acmeValidationExtBytes);
        ASN1OctetString rfc8737OctetString = (ASN1OctetString)ASN1OctetString.fromByteArray((byte[])octetString.getOctets());
        String actualContent = Base64.getEncoder().encodeToString(rfc8737OctetString.getOctets());
        if (rfc8737OctetString.getOctets().length > 32) {
            String msg2 = "actualContent has unexpected length of rfc8737OctetString : " + rfc8737OctetString.getOctets().length;
            this.LOG.info(msg2);
            throw new CertificateException(msg2);
        }
        this.LOG.debug("read challenge response: " + actualContent);
        return actualContent;
    }

    private void validateALPNCertificate(String host, int port, X509Certificate cert) throws CertificateException {
        if (this.LOG.isDebugEnabled()) {
            try {
                this.LOG.debug("alpn certificate : {}", (Object)Base64.getEncoder().encodeToString(cert.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                String msg = "Encoding problem parsing ALPN certificate";
                this.LOG.info(msg);
                throw e;
            }
        }
        if (cert.getSubjectAlternativeNames() == null || cert.getSubjectAlternativeNames().isEmpty()) {
            String msg = "no SAN entry available in certificate provided by " + host + ":" + port;
            this.LOG.info(msg);
            throw new CertificateException(msg);
        }
        if (cert.getSubjectAlternativeNames().size() > 1) {
            String msg = "more than one SAN entry (#" + cert.getSubjectAlternativeNames().size() + ") included in certificate provided by " + host + ":" + port;
            this.LOG.info(msg);
            throw new CertificateException(msg);
        }
        Collection<List<?>> altNames = cert.getSubjectAlternativeNames();
        if (altNames != null) {
            for (List<?> altName : altNames) {
                int altNameType = (Integer)altName.get(0);
                if (2 == altNameType) {
                    String sanValue = "";
                    if (altName.get(1) instanceof String) {
                        sanValue = ((String)altName.get(1)).toLowerCase();
                    } else if (altName.get(1) instanceof byte[]) {
                        sanValue = new String((byte[])altName.get(1)).toLowerCase();
                    }
                    if (host.equalsIgnoreCase(sanValue)) {
                        this.LOG.debug("SAN entry '{}' machtes expected host '{}'", (Object)sanValue, (Object)host);
                        continue;
                    }
                    String msg = "SAN entry value (" + sanValue + ") in alpn certificate provided by '" + host + ":" + port + "', does not match expected host '" + host + "'";
                    this.LOG.info(msg);
                    throw new CertificateException(msg);
                }
                String msg = "unexpected SAN entry type (" + altNameType + ") in alpn certificate provided by '" + host + ":" + port + "', 'DNS' (2) expected.";
                this.LOG.info(msg);
                throw new CertificateException(msg);
            }
        }
        if (!cert.getCriticalExtensionOIDs().contains(ACME_VALIDATION_OID)) {
            String msg = "ACME validation oid is NOT present and NOT marked as critical in certificate provided by '" + host + ":" + port + "'";
            this.LOG.info(msg);
            throw new CertificateException(msg);
        }
        this.LOG.debug("ACME validation oid is present and marked as critical!");
    }

    private List<String> extractTokenFrom(Record[] lookupResult) {
        ArrayList<String> tokenList = new ArrayList<String>();
        if (lookupResult != null) {
            for (Record record : lookupResult) {
                this.LOG.debug("Found DNS entry solving '{}'", (Object)record);
                tokenList.addAll(((TXTRecord)record).getStrings());
            }
        }
        return tokenList;
    }
}

