/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.internal;

import de.tototec.cmdoption.internal.F0;
import de.tototec.cmdoption.internal.F1;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Optional<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Optional<?> NONE = new Optional();
    private final boolean isNone;
    private final T optional;

    public static <S> Optional<S> some(S s) {
        return new Optional<S>(s);
    }

    public static <S> Optional<S> lift(S s) {
        if (s == null) {
            return new Optional();
        }
        return new Optional<S>(s);
    }

    public static <N> Optional<N> none() {
        return NONE;
    }

    private Optional() {
        this.isNone = true;
        this.optional = null;
    }

    private Optional(T t) {
        this.isNone = false;
        this.optional = t;
    }

    public T get() {
        if (this.isDefined()) {
            return this.optional;
        }
        throw new NullPointerException("Optional value not defined.");
    }

    public T getOrElse(F0<T> f0) {
        if (this.isDefined()) {
            return this.optional;
        }
        return f0.apply();
    }

    public T orNull() {
        return this.isDefined() ? (T)this.optional : null;
    }

    public boolean isDefined() {
        return !this.isNone;
    }

    public boolean isEmpty() {
        return this.isNone;
    }

    public Optional<?> adapt() {
        return this.isDefined() ? Optional.some(this.get()) : Optional.none();
    }

    public List<T> toList() {
        return this.isDefined() ? Arrays.asList(this.optional) : Collections.emptyList();
    }

    @Override
    public Iterator<T> iterator() {
        return this.toList().iterator();
    }

    public <R> Optional<R> map(F1<? super T, ? extends R> f1) {
        return this.isEmpty() ? Optional.none() : Optional.some(f1.apply(this.get()));
    }

    public <R> Optional<R> flatMap(F1<? super T, ? extends Optional<R>> f1) {
        return this.isEmpty() ? Optional.none() : f1.apply(this.get());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + (this.isDefined() ? this.optional : "") + ")";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.isNone ? 1231 : 1237);
        n = 31 * n + (this.optional == null ? 0 : this.optional.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Optional optional = (Optional)object;
        if (this.isNone != optional.isNone) {
            return false;
        }
        return !(this.optional == null ? optional.optional != null : !this.optional.equals(optional.optional));
    }
}

