/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.internal;

import de.tototec.cmdoption.internal.Logger;
import java.util.logging.Level;

public class LoggerFactory {
    private static volatile transient boolean slf4ClassTestedButUnavailable = false;

    public static Logger getLogger(Class<?> clazz) {
        if (!slf4ClassTestedButUnavailable) {
            try {
                return new Slf4jLogger(clazz);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                slf4ClassTestedButUnavailable = true;
            }
        }
        return new JavaUtilLogger(clazz);
    }

    public static class DummyLogger
    implements Logger {
        @Override
        public boolean isErrorEnabled() {
            return false;
        }

        @Override
        public boolean isWarnEnabled() {
            return false;
        }

        @Override
        public boolean isInfoEnabled() {
            return false;
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        @Override
        public boolean isTraceEnabled() {
            return false;
        }

        @Override
        public void error(String string, Object ... objectArray) {
        }

        @Override
        public void warn(String string, Object ... objectArray) {
        }

        @Override
        public void info(String string, Object ... objectArray) {
        }

        @Override
        public void debug(String string, Object ... objectArray) {
        }

        @Override
        public void trace(String string, Object ... objectArray) {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class JavaUtilLogger
    implements Logger {
        private final java.util.logging.Logger underlying;

        public JavaUtilLogger(Class<?> clazz) {
            this.underlying = java.util.logging.Logger.getLogger(clazz.getName());
        }

        protected Object[] formattedMsgAndCause(String string, Object ... objectArray) {
            String string2;
            Throwable throwable;
            if (objectArray != null && objectArray.length > 0) {
                int n;
                if (objectArray[objectArray.length - 1] instanceof Throwable) {
                    n = objectArray.length - 1;
                    throwable = (Throwable)objectArray[objectArray.length - 1];
                } else {
                    n = objectArray.length;
                    throwable = null;
                }
                if (n > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl = false;
                    int n2 = 0;
                    for (int i = 0; i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (n2 < n) {
                            if (bl) {
                                bl = false;
                                if (c == '}') {
                                    stringBuilder.append(objectArray[n2]);
                                    ++n2;
                                    continue;
                                }
                                stringBuilder.append("{");
                            } else if (c == '{') {
                                bl = true;
                                continue;
                            }
                        }
                        stringBuilder.append(c);
                    }
                    if (bl) {
                        stringBuilder.append("{");
                    }
                    string2 = stringBuilder.toString();
                } else {
                    string2 = string;
                }
            } else {
                string2 = string;
                throwable = null;
            }
            return new Object[]{string2, throwable};
        }

        private void log(Level level, String string, Object ... objectArray) {
            if (this.underlying.isLoggable(level)) {
                Object[] objectArray2 = this.formattedMsgAndCause(string, objectArray);
                String string2 = (String)objectArray2[0];
                Throwable throwable = (Throwable)objectArray2[1];
                this.underlying.log(level, string2, throwable);
            }
        }

        @Override
        public boolean isErrorEnabled() {
            return this.underlying.isLoggable(Level.SEVERE);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.underlying.isLoggable(Level.WARNING);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.underlying.isLoggable(Level.INFO);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.underlying.isLoggable(Level.FINE);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.underlying.isLoggable(Level.FINER);
        }

        @Override
        public void error(String string, Object ... objectArray) {
            this.log(Level.SEVERE, string, objectArray);
        }

        @Override
        public void warn(String string, Object ... objectArray) {
            this.log(Level.WARNING, string, objectArray);
        }

        @Override
        public void info(String string, Object ... objectArray) {
            this.log(Level.INFO, string, objectArray);
        }

        @Override
        public void debug(String string, Object ... objectArray) {
            this.log(Level.FINE, string, objectArray);
        }

        @Override
        public void trace(String string, Object ... objectArray) {
            this.log(Level.FINER, string, objectArray);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.underlying + ")";
        }
    }

    public static class Slf4jLogger
    implements Logger {
        private final org.slf4j.Logger underlying;

        public Slf4jLogger(Class<?> clazz) {
            this.underlying = org.slf4j.LoggerFactory.getLogger(clazz);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.underlying.isErrorEnabled();
        }

        @Override
        public boolean isWarnEnabled() {
            return this.underlying.isWarnEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.underlying.isInfoEnabled();
        }

        @Override
        public boolean isDebugEnabled() {
            return this.underlying.isDebugEnabled();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.underlying.isTraceEnabled();
        }

        @Override
        public void error(String string, Object ... objectArray) {
            this.underlying.error(string, objectArray);
        }

        @Override
        public void warn(String string, Object ... objectArray) {
            this.underlying.warn(string, objectArray);
        }

        @Override
        public void info(String string, Object ... objectArray) {
            this.underlying.info(string, objectArray);
        }

        @Override
        public void debug(String string, Object ... objectArray) {
            this.underlying.debug(string, objectArray);
        }

        @Override
        public void trace(String string, Object ... objectArray) {
            this.underlying.trace(string, objectArray);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.underlying + ")";
        }
    }
}

