/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.handler;

import de.tototec.cmdoption.handler.CmdOptionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandlerException;
import de.tototec.cmdoption.internal.FList;
import de.tototec.cmdoption.internal.I18n;
import de.tototec.cmdoption.internal.I18nFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.EnumSet;

public class EnumHandler
implements CmdOptionHandler {
    @Override
    public boolean canHandle(AccessibleObject accessibleObject, int n) {
        if (n == 1) {
            if (accessibleObject instanceof Field) {
                Field field = (Field)accessibleObject;
                return !Modifier.isFinal(field.getModifiers()) && field.getType().isEnum();
            }
            if (accessibleObject instanceof Method) {
                Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
                return classArray.length == 1 && classArray[0].isEnum();
            }
        }
        return false;
    }

    @Override
    public void applyParams(Object object, AccessibleObject accessibleObject, String[] stringArray, String string) throws CmdOptionHandlerException {
        try {
            if (accessibleObject instanceof Field) {
                Field field = (Field)accessibleObject;
                Class<?> clazz = field.getType();
                Object obj = Enum.valueOf(clazz, stringArray[0]);
                field.set(object, obj);
            } else if (accessibleObject instanceof Method) {
                Method method = (Method)accessibleObject;
                Class<?> clazz = method.getParameterTypes()[0];
                Object obj = Enum.valueOf(clazz, stringArray[0]);
                method.invoke(object, obj);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Class<Object> clazz = accessibleObject instanceof Field ? ((Field)accessibleObject).getType() : (accessibleObject instanceof Method ? ((Method)accessibleObject).getParameterTypes()[0] : Enum.class);
            I18n i18n = I18nFactory.getI18n(EnumHandler.class);
            I18n.PreparedI18n preparedI18n = i18n.preparetr("Invalid enum value: \"{0}\". Supported values: {1}", stringArray[0], FList.mkString(EnumSet.allOf(clazz), ", "));
            throw new CmdOptionHandlerException(preparedI18n.notr(), illegalArgumentException, preparedI18n.tr());
        }
        catch (Exception exception) {
            I18n i18n = I18nFactory.getI18n(EnumHandler.class);
            I18n.PreparedI18n preparedI18n = i18n.preparetr("Could not apply parameters: {0} to field/method {1}", Arrays.toString(stringArray), accessibleObject);
            throw new CmdOptionHandlerException(preparedI18n.notr(), exception, preparedI18n.tr());
        }
    }
}

