/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.handler;

import de.tototec.cmdoption.handler.CmdOptionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandlerException;
import de.tototec.cmdoption.internal.I18n;
import de.tototec.cmdoption.internal.I18nFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ByteHandler
implements CmdOptionHandler {
    @Override
    public boolean canHandle(AccessibleObject accessibleObject, int n) {
        Method method;
        if (accessibleObject instanceof Field && n == 1) {
            Field field = (Field)accessibleObject;
            return !Modifier.isFinal(field.getModifiers()) && (field.getType().equals(Byte.class) || field.getType().equals(Byte.TYPE));
        }
        if (accessibleObject instanceof Method && n == 1 && (method = (Method)accessibleObject).getParameterTypes().length == 1) {
            Class<?> clazz = method.getParameterTypes()[0];
            return Byte.TYPE.equals(clazz) || Byte.class.equals(clazz);
        }
        return false;
    }

    @Override
    public void applyParams(Object object, AccessibleObject accessibleObject, String[] stringArray, String string) throws CmdOptionHandlerException {
        Object object2;
        byte by = 0;
        try {
            object2 = stringArray[0];
            by = Byte.parseByte((String)object2);
        }
        catch (NumberFormatException numberFormatException) {
            I18n i18n = I18nFactory.getI18n(ByteHandler.class);
            I18n.PreparedI18n preparedI18n = i18n.preparetr("Could not read byte value \"{0}\".", stringArray[0]);
            throw new CmdOptionHandlerException(preparedI18n.notr(), numberFormatException, preparedI18n.tr());
        }
        try {
            if (accessibleObject instanceof Field) {
                object2 = (Field)accessibleObject;
                ((Field)object2).set(object, by);
            } else {
                object2 = (Method)accessibleObject;
                ((Method)object2).invoke(object, by);
            }
        }
        catch (Exception exception) {
            I18n i18n = I18nFactory.getI18n(ByteHandler.class);
            I18n.PreparedI18n preparedI18n = i18n.preparetr("Could not apply argument \"{0}\".", stringArray[0]);
            throw new CmdOptionHandlerException(preparedI18n.notr(), exception, preparedI18n.tr());
        }
    }
}

