/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption;

import de.tototec.cmdoption.LineLengthDetector;
import de.tototec.cmdoption.internal.Logger;
import de.tototec.cmdoption.internal.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TtyLineLengthDetector
implements LineLengthDetector {
    private final Logger log = LoggerFactory.getLogger(TtyLineLengthDetector.class);

    @Override
    public Integer detectOrNull() {
        File file = new File("/dev/tty");
        if (!file.exists()) {
            this.log.debug("/dev/tty does not exist", new Object[0]);
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ProcessBuilder processBuilder = new ProcessBuilder("stty", "-a", "-F", file.getPath());
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            this.copy(inputStream, byteArrayOutputStream);
            process.waitFor();
            inputStream.close();
            String string = byteArrayOutputStream.toString();
            this.log.trace("Output of stty: {}", string);
            Pattern pattern = Pattern.compile("columns\\s+=\\s+([^;]*)[;\\n\\r]");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                return Integer.parseInt(matcher.group(1));
            }
            Pattern pattern2 = Pattern.compile("columns\\s+([^;]*)[;\\n\\r]");
            Matcher matcher2 = pattern2.matcher(string);
            if (matcher2.find()) {
                return Integer.parseInt(matcher2.group(1));
            }
            return null;
        }
        catch (Exception exception) {
            this.log.debug("Could not eval columns with tty", exception);
            return null;
        }
    }

    private void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }
}

