/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption;

import de.tototec.cmdoption.CmdCommand;
import de.tototec.cmdoption.CmdOption;
import de.tototec.cmdoption.CmdOptionDelegate;
import de.tototec.cmdoption.CmdlineModel;
import de.tototec.cmdoption.CmdlineParserException;
import de.tototec.cmdoption.CommandHandle;
import de.tototec.cmdoption.DefaultUsageFormatter2;
import de.tototec.cmdoption.OptionHandle;
import de.tototec.cmdoption.TtyLineLengthDetector;
import de.tototec.cmdoption.UsageFormatter2;
import de.tototec.cmdoption.handler.AddToCollectionHandler;
import de.tototec.cmdoption.handler.BooleanHandler;
import de.tototec.cmdoption.handler.BooleanOptionHandler;
import de.tototec.cmdoption.handler.ByteHandler;
import de.tototec.cmdoption.handler.CmdOptionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandlerException;
import de.tototec.cmdoption.handler.EnumHandler;
import de.tototec.cmdoption.handler.IntegerHandler;
import de.tototec.cmdoption.handler.LongHandler;
import de.tototec.cmdoption.handler.PutIntoMapHandler;
import de.tototec.cmdoption.handler.StringFieldHandler;
import de.tototec.cmdoption.handler.StringMethodHandler;
import de.tototec.cmdoption.internal.F0;
import de.tototec.cmdoption.internal.F1;
import de.tototec.cmdoption.internal.FList;
import de.tototec.cmdoption.internal.I18n;
import de.tototec.cmdoption.internal.I18nFactory;
import de.tototec.cmdoption.internal.Logger;
import de.tototec.cmdoption.internal.LoggerFactory;
import de.tototec.cmdoption.internal.Optional;
import de.tototec.cmdoption.internal.Procedure1;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class CmdlineParser {
    private final I18n i18n = I18nFactory.getI18n(CmdlineParser.class);
    private final Logger log = LoggerFactory.getLogger(CmdlineParser.class);
    private Optional<OptionHandle> parameter = Optional.none();
    private final List<OptionHandle> options = new LinkedList<OptionHandle>();
    private final Map<String, OptionHandle> quickOptionMap = new LinkedHashMap<String, OptionHandle>();
    private final List<CommandHandle> commands = new LinkedList<CommandHandle>();
    private final Map<String, CommandHandle> quickCommandMap = new LinkedHashMap<String, CommandHandle>();
    private String defaultCommandName = null;
    private final Map<Class<? extends CmdOptionHandler>, CmdOptionHandler> handlerRegistry;
    private UsageFormatter2 usageFormatter;
    private String programName;
    private String parsedCommandName;
    private String aboutLine;
    private boolean debugAllowed = true;
    private boolean debugMode = false;
    final String DEBUG_PREFIX = "CMDOPTION_DEBUG: ";
    private final CmdlineParser parent;
    private ResourceBundle resourceBundle;
    private Optional<String> argsFromFilePrefix = Optional.some("@");
    private Optional<String> aggregateShortOptionsWithPrefix = Optional.none();
    private Optional<String> shortOptionsWithArgsPrefix = Optional.none();
    private boolean stopAcceptOptionAfterParameterIsSet = false;

    protected CmdlineParser(CmdlineParser cmdlineParser, String string, Object object) {
        this.parent = cmdlineParser;
        this.debugAllowed = cmdlineParser.debugAllowed;
        this.debugMode = cmdlineParser.debugMode;
        this.programName = string;
        this.handlerRegistry = cmdlineParser.handlerRegistry;
        this.resourceBundle = cmdlineParser.resourceBundle;
        this.argsFromFilePrefix = cmdlineParser.argsFromFilePrefix;
        this.usageFormatter = cmdlineParser.usageFormatter;
        this.addOptions(object);
    }

    public CmdlineParser(Object ... objectArray) {
        this.parent = null;
        this.programName = "<main class>";
        this.usageFormatter = new DefaultUsageFormatter2(true, 80, new TtyLineLengthDetector());
        this.handlerRegistry = new LinkedHashMap<Class<? extends CmdOptionHandler>, CmdOptionHandler>();
        FList.foreach(this.defaultHandlers(), new Procedure1<CmdOptionHandler>(){

            @Override
            public void apply(CmdOptionHandler cmdOptionHandler) {
                CmdlineParser.this.registerHandler(cmdOptionHandler);
            }
        });
        this.addObject(objectArray);
    }

    public List<CmdOptionHandler> defaultHandlers() {
        return Arrays.asList(new BooleanOptionHandler(), new BooleanHandler(), new StringFieldHandler(), new PutIntoMapHandler(), new AddToCollectionHandler(), new StringMethodHandler(), new LongHandler(), new IntegerHandler(), new ByteHandler(), new EnumHandler());
    }

    private void debug(String string, Object ... objectArray) {
        if (this.log.isDebugEnabled()) {
            if (objectArray == null || objectArray.length == 0) {
                this.log.debug(string, new Object[0]);
            } else {
                this.log.debug(MessageFormat.format(string, objectArray), new Object[0]);
            }
        }
        if (this.parent != null) {
            this.parent.debug(string, objectArray);
        } else if (this.debugMode) {
            if (objectArray == null || objectArray.length == 0) {
                System.out.println("CMDOPTION_DEBUG: " + string);
            } else {
                System.out.println("CMDOPTION_DEBUG: " + MessageFormat.format(string, objectArray));
            }
        }
    }

    public void setDebugMode(final boolean bl) {
        this.debugMode = bl;
        FList.foreach(this.commands, new Procedure1<CommandHandle>(){

            @Override
            public void apply(CommandHandle commandHandle) {
                commandHandle.getCmdlineParser().setDebugMode(bl);
            }
        });
    }

    public void setDebugModeAllowed(boolean bl) {
        this.debugAllowed = bl;
    }

    public void setUsageFormatter(UsageFormatter2 usageFormatter2) {
        this.usageFormatter = usageFormatter2;
    }

    public void setStopAcceptOptionsAfterParameterIsSet(boolean bl) {
        this.stopAcceptOptionAfterParameterIsSet = bl;
    }

    public void setDefaultCommandName(String string) {
        this.defaultCommandName = string;
    }

    public void setDefaultCommandClass(Class<?> clazz) {
        CmdCommand cmdCommand = clazz.getAnnotation(CmdCommand.class);
        if (cmdCommand == null) {
            throw new IllegalArgumentException("Given class is not annotated with @" + CmdCommand.class.getSimpleName());
        }
        if (cmdCommand.names() == null || cmdCommand.names().length == 0 || cmdCommand.names()[0].length() == 0) {
            throw new IllegalArgumentException("Given default command class has no valid name");
        }
        this.setDefaultCommandName(cmdCommand.names()[0]);
    }

    public void parse(String ... stringArray) {
        this.parse(false, true, stringArray);
    }

    private String debugState(final String string) {
        return string + "Parameter: " + this.parameter.orNull() + "\n" + string + "Options: " + FList.mkString(this.options, "\n" + string + "  ", ",\n" + string + "  ", "") + "\n" + string + "Commands: " + FList.mkString(FList.map(this.commands, new F1<CommandHandle, String>(){

            @Override
            public String apply(CommandHandle commandHandle) {
                return commandHandle.toString() + "\n" + commandHandle.getCmdlineParser().debugState(string + "  | ");
            }
        }), "\n" + string + "  ", ",\n" + string + "  ", "") + "\n" + string + "ResourceBundle: " + this.resourceBundle + "\n" + string + "Locale: " + (this.resourceBundle == null ? null : this.resourceBundle.getLocale()) + "\n" + string + "CmdOptionHandlers: " + FList.mkString(this.handlerRegistry.entrySet(), "\n" + string + "  ", "\n" + string + "  ", "");
    }

    public void parse(boolean bl, boolean bl2, String ... stringArray) {
        Object object;
        Object object2;
        Object[] objectArray;
        int n;
        if (this.log.isDebugEnabled()) {
            this.log.debug("About to start parsing. dryrun: " + bl + ", detectHelpAndSkipValidation: " + bl2 + ", state: " + this.debugState("  "), new Object[0]);
        }
        if (this.defaultCommandName != null && !this.quickCommandMap.containsKey(this.defaultCommandName)) {
            I18n.PreparedI18n preparedI18n = this.i18n.preparetr("Default command \"{0}\" is not a known command.", this.defaultCommandName);
            throw new CmdlineParserException(preparedI18n.notr(), preparedI18n.tr());
        }
        String[] stringArray2 = stringArray == null ? new String[]{} : (this.argsFromFilePrefix.isDefined() ? FList.flatMap(stringArray, new F1<String, List<String>>(){

            @Override
            public List<String> apply(String string) {
                if (string.startsWith((String)CmdlineParser.this.argsFromFilePrefix.get())) {
                    CmdlineParser.this.debug("Expanding {0} into argument list", new Object[]{string});
                    File file = new File(string.substring(1));
                    if (file.exists() && file.isFile()) {
                        try {
                            String string2;
                            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                            LinkedList<String> linkedList = new LinkedList<String>();
                            while ((string2 = bufferedReader.readLine()) != null) {
                                linkedList.add(string2);
                            }
                            bufferedReader.close();
                            return linkedList;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            I18n.PreparedI18n preparedI18n = CmdlineParser.this.i18n.preparetr("File referenced via {0} does not exist.", string);
                            throw new CmdlineParserException(preparedI18n.notr(), fileNotFoundException, preparedI18n.tr());
                        }
                        catch (IOException iOException) {
                            I18n.PreparedI18n preparedI18n = CmdlineParser.this.i18n.preparetr("File referenced via {0} could not be read.", string);
                            throw new CmdlineParserException(preparedI18n.notr(), iOException, preparedI18n.tr());
                        }
                    }
                    I18n.PreparedI18n preparedI18n = CmdlineParser.this.i18n.preparetr("File referenced via {0} does not exist.", string);
                    throw new CmdlineParserException(preparedI18n.notr(), preparedI18n.tr());
                }
                return Arrays.asList(string);
            }
        }).toArray(new String[0]) : stringArray);
        if (!bl) {
            this.debug("Parsing...", new Object[0]);
            this.parse(true, bl2, stringArray2);
        }
        if (bl) {
            this.validateOptions();
        }
        boolean bl3 = true;
        LinkedHashMap<Object, Integer> linkedHashMap = new LinkedHashMap<Object, Integer>();
        for (OptionHandle object32 : this.options) {
            linkedHashMap.put(object32, 0);
        }
        if (this.parameter.isDefined()) {
            linkedHashMap.put(this.parameter.get(), 0);
        }
        boolean bl4 = false;
        String string = this.aggregateShortOptionsWithPrefix.getOrElse(new F0<String>(){

            @Override
            public String apply() {
                return "";
            }
        });
        LinkedHashMap<String, OptionHandle> linkedHashMap2 = new LinkedHashMap<String, OptionHandle>();
        int n2 = string.length();
        if (this.aggregateShortOptionsWithPrefix.isDefined()) {
            int string2 = 1 + n2;
            for (Map.Entry<String, OptionHandle> n4 : this.quickOptionMap.entrySet()) {
                if (!n4.getKey().startsWith(string) || n4.getKey().length() != string2) continue;
                linkedHashMap2.put(n4.getKey().substring(n2), n4.getValue());
            }
        }
        String string3 = this.shortOptionsWithArgsPrefix.getOrElse(new F0<String>(){

            @Override
            public String apply() {
                return "";
            }
        });
        LinkedHashMap linkedHashMap3 = new LinkedHashMap();
        int n3 = string3.length();
        if (this.shortOptionsWithArgsPrefix.isDefined()) {
            n = 1 + n3;
            for (Map.Entry entry : this.quickOptionMap.entrySet()) {
                if (!((String)entry.getKey()).startsWith(string3) || ((String)entry.getKey()).length() != n || ((OptionHandle)entry.getValue()).getArgsCount() != 1) continue;
                linkedHashMap3.put(((String)entry.getKey()).substring(n3), entry.getValue());
            }
        }
        n = -1;
        Object object3 = stringArray2;
        while (((String[])object3).length > n + 1) {
            if (n >= 0) {
                object3 = (String[])Arrays.copyOfRange(object3, ++n, ((Object)object3).length);
            }
            n = 0;
            Object object4 = object3[n];
            if (bl3 && "--".equals(object4)) {
                this.debug("Found \"--\". Disabling parsing subsequent options.", new Object[0]);
                bl3 = false;
            } else {
                Map.Entry preparedI18n;
                if (this.debugAllowed && ((String)object4).equals("--CMDOPTION_DEBUG")) {
                    if (this.debugMode) continue;
                    this.setDebugMode(true);
                    this.debug("Enabled debug mode\n" + this.debugState(""), new Object[0]);
                    continue;
                }
                if (bl3 && this.quickOptionMap.containsKey(object4)) {
                    preparedI18n = this.quickOptionMap.get(object4);
                    linkedHashMap.put(preparedI18n, (Integer)linkedHashMap.get(preparedI18n) + 1);
                    if (((OptionHandle)((Object)preparedI18n)).isHelp()) {
                        this.debug("Detected a help request through: " + (String)object4, new Object[0]);
                        bl4 = true;
                    }
                    if (((Object)object3).length <= n + ((OptionHandle)((Object)preparedI18n)).getArgsCount()) {
                        objectArray = this.i18n.preparetr("Missing argument(s): {0}. Option \"{1}\" requires {2} arguments, but you gave {3}.", FList.mkString(Arrays.asList(((OptionHandle)((Object)preparedI18n)).getArgs()).subList(((Object)object3).length - n - 1, ((OptionHandle)((Object)preparedI18n)).getArgsCount()), ", "), object4, ((OptionHandle)((Object)preparedI18n)).getArgsCount(), ((Object)object3).length - n - 1);
                        throw new CmdlineParserException(objectArray.notr(), objectArray.tr());
                    }
                    objectArray = (String[])Arrays.copyOfRange(object3, n + 1, n + 1 + ((OptionHandle)((Object)preparedI18n)).getArgsCount());
                    n += ((OptionHandle)((Object)preparedI18n)).getArgsCount();
                    object2 = ((OptionHandle)((Object)preparedI18n)).getElement();
                    CmdOptionHandler cmdOptionHandler = ((OptionHandle)((Object)preparedI18n)).getCmdOptionHandler();
                    if (bl) continue;
                    try {
                        boolean bl7 = ((AccessibleObject)object2).isAccessible();
                        if (!bl7) {
                            ((AccessibleObject)object2).setAccessible(true);
                        }
                        cmdOptionHandler.applyParams(((OptionHandle)((Object)preparedI18n)).getObject(), (AccessibleObject)object2, (String[])objectArray, (String)object4);
                        if (bl7) continue;
                        ((AccessibleObject)object2).setAccessible(bl7);
                        continue;
                    }
                    catch (CmdOptionHandlerException cmdOptionHandlerException) {
                        throw new CmdlineParserException(cmdOptionHandlerException.getMessage(), cmdOptionHandlerException, cmdOptionHandlerException.getLocalizedMessage());
                    }
                    catch (Exception exception) {
                        I18n.PreparedI18n preparedI18n2 = this.i18n.preparetr("Could not apply parameters {0} to field/method {1}", Arrays.toString(objectArray), object2);
                        throw new CmdlineParserException(preparedI18n2.notr(), exception, preparedI18n2.tr());
                    }
                }
                if (bl3 && this.quickCommandMap.containsKey(object4)) {
                    preparedI18n = this.quickCommandMap.get(object4);
                    if (!bl) {
                        this.parsedCommandName = object4;
                    }
                    ((CommandHandle)((Object)preparedI18n)).getCmdlineParser().parse(bl, bl2, (String[])Arrays.copyOfRange(object3, n + 1, ((Object)object3).length));
                    break;
                }
            }
            if (bl3 && this.aggregateShortOptionsWithPrefix.isDefined() && ((String)object4).startsWith(string) && ((String)object4).length() > n2 + 1) {
                boolean bl5 = false;
                objectArray = ((String)object4).substring(n2).toCharArray();
                object2 = new LinkedList();
                int n4 = 1;
                for (Object object5 : objectArray) {
                    object = (OptionHandle)linkedHashMap2.get(String.valueOf((char)object5));
                    if (object == null) {
                        bl5 = true;
                        break;
                    }
                    if (((Object)object3).length < n4 + ((OptionHandle)object).getArgsCount()) {
                        I18n.PreparedI18n preparedI18n = this.i18n.preparetr("Missing argument(s): {0}. Option \"{1}\" requires {2} arguments, but you gave {3}.", FList.mkString(Arrays.asList(((OptionHandle)object).getArgs()).subList(((Object)object3).length - n4, ((OptionHandle)object).getArgsCount()), ", "), string + (char)object5, ((OptionHandle)object).getArgsCount(), ((Object)object3).length - n4);
                        throw new CmdlineParserException(preparedI18n.notr(), preparedI18n.tr());
                    }
                    object2.add(string + (char)object5);
                    for (int i = 0; i < ((OptionHandle)object).getArgsCount(); ++i) {
                        object2.add(object3[i + n4]);
                        ++n4;
                    }
                }
                if (!bl5) {
                    Object[] string32 = (String[])Arrays.copyOfRange(object3, n4, ((Object)object3).length);
                    object2.addAll(Arrays.asList(string32));
                    object3 = object2.toArray(new String[0]);
                    n = -1;
                    continue;
                }
            }
            if (bl3 && this.shortOptionsWithArgsPrefix.isDefined() && ((String)object4).startsWith(string3) && ((String)object4).length() > n3 + 1) {
                String string4 = ((String)object4).substring(n3, n3 + 1);
                objectArray = ((String)object4).substring(n3 + 1);
                object2 = new LinkedList();
                OptionHandle optionHandle = (OptionHandle)linkedHashMap3.get(string4);
                if (optionHandle != null && optionHandle.getArgsCount() == 1) {
                    object2.add(string3 + string4);
                    object2.add(objectArray);
                    String[] stringArray3 = (String[])Arrays.copyOfRange(object3, 1, ((Object)object3).length);
                    object2.addAll(Arrays.asList(stringArray3));
                    object3 = object2.toArray(new String[0]);
                    n = -1;
                    continue;
                }
            }
            if (this.parameter.isEmpty() && this.defaultCommandName != null && this.quickCommandMap.containsKey(this.defaultCommandName)) {
                this.debug("Unsupported option '" + (String)object4 + "' found, assuming default command: " + this.defaultCommandName, new Object[0]);
                CommandHandle commandHandle = this.quickCommandMap.get(this.defaultCommandName);
                if (!bl) {
                    this.parsedCommandName = this.defaultCommandName;
                }
                commandHandle.getCmdlineParser().parse(bl, bl2, (String[])Arrays.copyOfRange(object3, n, ((Object)object3).length));
                break;
            }
            if (this.parameter.isDefined()) {
                OptionHandle optionHandle = this.parameter.get();
                linkedHashMap.put(optionHandle, (Integer)linkedHashMap.get(optionHandle) + 1);
                if (this.stopAcceptOptionAfterParameterIsSet && bl3) {
                    this.debug("Found a parameter and stopAcceptOptionAfterParameterIsSet is enabled. Disabling parsing subsequent options.", new Object[0]);
                    bl3 = false;
                }
                if (((Object)object3).length <= n + optionHandle.getArgsCount() - 1) {
                    int n5 = ((Object)object3).length - n;
                    object2 = this.i18n.preparetr("Missing arguments: {0} Parameter requires {1} arguments, but you gave {2}.", Arrays.asList(optionHandle.getArgs()).subList(n5, optionHandle.getArgsCount()), optionHandle.getArgsCount(), n5);
                    throw new CmdlineParserException(object2.notr(), object2.tr());
                }
                objectArray = (String[])Arrays.copyOfRange(object3, n, n + optionHandle.getArgsCount());
                n += optionHandle.getArgsCount() - 1;
                object2 = optionHandle.getElement();
                CmdOptionHandler cmdOptionHandler = optionHandle.getCmdOptionHandler();
                if (bl) continue;
                try {
                    this.debug("Apply main parameter from parameters: {0}", FList.mkString(objectArray, ", "));
                    boolean bl6 = ((AccessibleObject)object2).isAccessible();
                    if (!bl6) {
                        ((AccessibleObject)object2).setAccessible(true);
                    }
                    cmdOptionHandler.applyParams(optionHandle.getObject(), (AccessibleObject)object2, (String[])objectArray, (String)object4);
                    if (bl6) continue;
                    ((AccessibleObject)object2).setAccessible(bl6);
                    continue;
                }
                catch (CmdOptionHandlerException cmdOptionHandlerException) {
                    throw new CmdlineParserException(cmdOptionHandlerException.getMessage(), cmdOptionHandlerException, cmdOptionHandlerException.getLocalizedMessage());
                }
                catch (Exception exception) {
                    I18n.PreparedI18n preparedI18n = this.i18n.preparetr("Could not apply parameters {0} to field/method {1}", Arrays.toString(objectArray), object2);
                    throw new CmdlineParserException(preparedI18n.notr(), exception, preparedI18n.tr());
                }
            }
            I18n.PreparedI18n preparedI18n = this.i18n.preparetr("Unsupported option or parameter found: {0}", object4);
            throw new CmdlineParserException(preparedI18n.notr(), preparedI18n.tr());
        }
        if (!bl2 || !bl4) {
            for (Map.Entry preparedI18n : linkedHashMap.entrySet()) {
                Object[] objectArray2;
                Object[] objectArray3;
                String string5;
                objectArray = (OptionHandle)preparedI18n.getKey();
                object2 = (String[])preparedI18n.getValue();
                if ((Integer)object2 >= objectArray.getMinCount() && (objectArray.getMaxCount() <= 0 || (Integer)object2 <= objectArray.getMaxCount())) continue;
                I18n.PreparedI18n preparedI18n3 = objectArray.getMaxCount() < 0 ? this.i18n.preparetr("at least {0}", objectArray.getMinCount()) : (objectArray.getMinCount() == objectArray.getMaxCount() ? this.i18n.preparetr("exactly {0}", objectArray.getMinCount()) : this.i18n.preparetr("between {0} and {1}", objectArray.getMinCount(), objectArray.getMaxCount()));
                if (objectArray.getNames() == null || objectArray.getNames().length == 0) {
                    string5 = I18n.marktr("Main parameter \"{0}\" was given {1} times, but must be given {2} times");
                    objectArray3 = new Object[]{FList.mkString(objectArray.getArgs(), " "), object2, preparedI18n3.notr()};
                    objectArray2 = new Object[]{FList.mkString(objectArray.getArgs(), " "), object2, preparedI18n3.tr()};
                } else {
                    string5 = I18n.marktr("Option \"{0}\" was given {1} times, but must be given {2} times");
                    objectArray3 = new Object[]{objectArray.getNames()[0], object2, preparedI18n3.notr()};
                    objectArray2 = new Object[]{objectArray.getNames()[0], object2, preparedI18n3.tr()};
                }
                throw new CmdlineParserException(MessageFormat.format(string5, objectArray3), this.i18n.tr(string5, objectArray2));
            }
            for (Map.Entry preparedI18n : linkedHashMap.entrySet()) {
                if ((Integer)preparedI18n.getValue() <= 0) continue;
                objectArray = (OptionHandle)preparedI18n.getKey();
                for (String string6 : objectArray.getRequires()) {
                    Integer n6;
                    OptionHandle optionHandle = this.quickOptionMap.get(string6);
                    if (optionHandle == null || (n6 = (Integer)linkedHashMap.get(optionHandle)) != null && n6 > 0) continue;
                    object = this.i18n.preparetr("When using option \"{0}\" also option \"{1}\" must be given.", objectArray.getNames()[0], string6);
                    throw new CmdlineParserException(object.notr(), object.tr());
                }
                for (String string7 : objectArray.getConflictsWith()) {
                    Integer n7;
                    OptionHandle optionHandle = this.quickOptionMap.get(string7);
                    if (optionHandle == null || (n7 = (Integer)linkedHashMap.get(optionHandle)) == null || n7 <= 0) continue;
                    object = this.i18n.preparetr("Options \"{0}\" and \"{1}\" cannot be used at the same time.", objectArray.getNames()[0], string7);
                    throw new CmdlineParserException(object.notr(), object.tr());
                }
            }
        }
    }

    public String getParsedCommandName() {
        return this.parsedCommandName;
    }

    public Object getParsedCommandObject() {
        if (this.parsedCommandName != null) {
            return this.quickCommandMap.get(this.parsedCommandName).getObject();
        }
        return null;
    }

    protected CmdOptionHandler findHandler(AccessibleObject accessibleObject, int n, Class<? extends CmdOptionHandler> clazz) {
        CmdOptionHandler cmdOptionHandler;
        block7: {
            block6: {
                CmdOptionHandler cmdOptionHandler2;
                cmdOptionHandler = null;
                if (clazz == null || clazz.equals(CmdOptionHandler.class)) break block6;
                if (this.handlerRegistry.containsKey(clazz)) {
                    cmdOptionHandler2 = this.handlerRegistry.get(clazz);
                } else {
                    try {
                        cmdOptionHandler2 = clazz.newInstance();
                    }
                    catch (Exception exception) {
                        I18n.PreparedI18n preparedI18n = this.i18n.preparetr("Could not create handler: {0}", clazz);
                        throw new CmdlineParserException(preparedI18n.notr(), exception, preparedI18n.tr());
                    }
                }
                if (!cmdOptionHandler2.canHandle(accessibleObject, n)) break block7;
                cmdOptionHandler = cmdOptionHandler2;
                break block7;
            }
            for (CmdOptionHandler cmdOptionHandler3 : this.handlerRegistry.values()) {
                if (!cmdOptionHandler3.canHandle(accessibleObject, n)) continue;
                cmdOptionHandler = cmdOptionHandler3;
                break;
            }
        }
        if (cmdOptionHandler == null && this.parent != null) {
            return this.parent.findHandler(accessibleObject, n, clazz);
        }
        return cmdOptionHandler;
    }

    public void addObject(Object ... objectArray) {
        for (Object object : objectArray) {
            boolean bl = this.addCommand(object);
            if (bl) continue;
            this.addOptions(object);
        }
    }

    protected boolean addCommand(Object object) {
        CmdCommand cmdCommand = object.getClass().getAnnotation(CmdCommand.class);
        if (cmdCommand == null) {
            return false;
        }
        String[] stringArray = cmdCommand.names();
        if (stringArray == null || stringArray.length == 0) {
            I18n.PreparedI18n preparedI18n = this.i18n.preparetr("Command found without required name in: {0}", object);
            throw new CmdlineParserException(preparedI18n.notr(), preparedI18n.tr());
        }
        CmdlineParser cmdlineParser = new CmdlineParser(this, stringArray[0], object);
        CommandHandle commandHandle = new CommandHandle(stringArray, cmdCommand.description(), cmdlineParser, object, cmdCommand.hidden());
        for (String string : commandHandle.getNames()) {
            if (this.quickCommandMap.containsKey(string) || this.quickOptionMap.containsKey(string)) {
                I18n.PreparedI18n preparedI18n = this.i18n.preparetr("Duplicate command/option name \"{0}\" found in: {1}", string, object);
                throw new CmdlineParserException(preparedI18n.notr(), preparedI18n.tr());
            }
            this.quickCommandMap.put(string, commandHandle);
        }
        this.commands.add(commandHandle);
        return true;
    }

    public void validate() {
        this.validateOptions();
        for (CommandHandle commandHandle : this.commands) {
            commandHandle.getCmdlineParser().validate();
        }
    }

    protected void validateOptions() {
        int n = 0;
        for (OptionHandle optionHandle : this.options) {
            String string;
            if (optionHandle.getNames() == null) {
                string = "<no name>";
                ++n;
            } else {
                string = optionHandle.getNames()[0];
            }
            if (optionHandle.getMaxCount() >= 0 && optionHandle.getMaxCount() < optionHandle.getMinCount()) {
                I18n.PreparedI18n preparedI18n = this.i18n.preparetr("The option \"{0}\" has inconsistent min..max count configuration (min={1}, max={2}).", string, optionHandle.getMinCount(), optionHandle.getMaxCount());
                throw new CmdlineParserException(preparedI18n.notr(), preparedI18n.tr());
            }
            for (String string2 : optionHandle.getRequires()) {
                if (this.quickOptionMap.get(string2) != null) continue;
                I18n.PreparedI18n preparedI18n = this.i18n.preparetr("The option \"{0}\" requires the unknown/missing option \"{1}\".", string, string2);
                throw new CmdlineParserException(preparedI18n.notr(), preparedI18n.tr());
            }
            for (String string2 : optionHandle.getConflictsWith()) {
                if (Arrays.asList(optionHandle.getNames()).contains(string2)) {
                    I18n.PreparedI18n preparedI18n = this.i18n.preparetr("Option \"{0}\" is configured to conflicts with itself.", string);
                    throw new CmdlineParserException(preparedI18n.notr(), preparedI18n.tr());
                }
                if (this.quickOptionMap.get(string2) != null) continue;
                I18n.PreparedI18n preparedI18n = this.i18n.preparetr("The option \"{0}\" conflicts with a unknown/missing option \"{1}\".", string, string2);
                throw new CmdlineParserException(preparedI18n.notr(), preparedI18n.tr());
            }
        }
        if (n > 1) {
            I18n.PreparedI18n preparedI18n = this.i18n.preparetr("More than one main parameter detected ({0}).", n);
            throw new CmdlineParserException(preparedI18n.notr(), preparedI18n.tr());
        }
    }

    protected boolean isVisible(Class<?> clazz, Member member) {
        if (clazz == null || member == null) {
            return false;
        }
        int n = member.getModifiers();
        if (Modifier.isPublic(n)) {
            return true;
        }
        if (Modifier.isProtected(n)) {
            return true;
        }
        return !Modifier.isPrivate(n) && clazz.getPackage().equals(member.getDeclaringClass().getPackage());
    }

    protected boolean isPublicOrProtected(Method method) {
        int n = method.getModifiers();
        return Modifier.isPublic(n) || Modifier.isProtected(n);
    }

    protected boolean isPackagePrivate(Method method) {
        int n = method.getModifiers();
        return !Modifier.isPublic(n) && !Modifier.isProtected(n) && !Modifier.isPrivate(n);
    }

    protected boolean isPrivate(Method method) {
        int n = method.getModifiers();
        return Modifier.isPrivate(n);
    }

    protected boolean containsMethod(Iterable<Method> iterable, Method method) {
        return this.findMethod(iterable, method) != null;
    }

    protected Method findMethod(Iterable<Method> iterable, Method method) {
        for (Method method2 : iterable) {
            Class<?>[] classArray;
            Class<?>[] classArray2;
            if (!method2.getName().equals(method.getName()) || (classArray2 = method2.getParameterTypes()).length != (classArray = method.getParameterTypes()).length) continue;
            boolean bl = true;
            for (int i = 0; i < classArray2.length; ++i) {
                bl &= classArray2[i].equals(classArray[i]);
            }
            if (!bl) continue;
            return method2;
        }
        return null;
    }

    protected void addOptions(Object object) {
        Object object2;
        Class<?> clazz = object.getClass();
        LinkedList<Field> linkedList = new LinkedList<Field>();
        LinkedList<Method> linkedList2 = new LinkedList<Method>();
        LinkedList<Method> linkedList3 = new LinkedList<Method>();
        LinkedList<Method> linkedList4 = new LinkedList<Method>();
        for (Class<?> clazz2 = clazz; clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
            linkedList.addAll(Arrays.asList(clazz2.getDeclaredFields()));
            for (Method method : clazz2.getDeclaredMethods()) {
                if (this.isPrivate(method)) {
                    linkedList2.add(method);
                    continue;
                }
                if (this.isPublicOrProtected(method)) {
                    if (this.containsMethod(linkedList3, method) || this.containsMethod(linkedList4, method)) continue;
                    linkedList4.add(method);
                    continue;
                }
                if (!this.isPackagePrivate(method) || !this.isPackagePrivate(method) || this.containsMethod(linkedList4, method)) continue;
                linkedList4.add(method);
            }
            object2 = clazz2.getPackage();
            if ((object2 != null || clazz2.getPackage() == null) && (object2 == null || object2.equals(clazz2.getPackage()))) continue;
            linkedList3.addAll(linkedList4);
            linkedList4.clear();
        }
        object2 = new LinkedHashSet();
        object2.addAll(linkedList);
        object2.addAll(linkedList2);
        object2.addAll(linkedList3);
        object2.addAll(linkedList4);
        this.options.addAll(this.inspectElements(object, (Set<AccessibleObject>)object2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<OptionHandle> inspectElements(Object object, Set<AccessibleObject> set) {
        LinkedList<OptionHandle> linkedList = new LinkedList<OptionHandle>();
        for (AccessibleObject accessibleObject : set) {
            Object object2;
            Object[] objectArray;
            CmdOptionDelegate cmdOptionDelegate = accessibleObject.getAnnotation(CmdOptionDelegate.class);
            if (accessibleObject instanceof Field && cmdOptionDelegate != null) {
                this.debug("Found delegate object at: {0} with mode: ", accessibleObject);
                try {
                    boolean bl = accessibleObject.isAccessible();
                    try {
                        if (!bl) {
                            accessibleObject.setAccessible(true);
                        }
                        objectArray = ((Field)accessibleObject).get(object);
                    }
                    finally {
                        if (!bl) {
                            accessibleObject.setAccessible(bl);
                        }
                    }
                    if (objectArray == null) continue;
                    switch (cmdOptionDelegate.value()) {
                        case OPTIONS: {
                            this.addOptions(objectArray);
                            break;
                        }
                        case COMMAND: {
                            this.addCommand(objectArray);
                            break;
                        }
                        case COMMAND_OR_OPTIONS: {
                            boolean bl2 = this.addCommand(objectArray);
                            if (bl2) break;
                            this.addOptions(objectArray);
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.debug("Could not scan delegate object at: {0}", accessibleObject);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.debug("Could not scan delegate object at: {0}", accessibleObject);
                }
                continue;
            }
            CmdOption cmdOption = accessibleObject.getAnnotation(CmdOption.class);
            if (cmdOption == null) continue;
            if (accessibleObject instanceof Field && Modifier.isFinal(((Field)accessibleObject).getModifiers())) {
                this.debug("Detected option on final field: {0}", accessibleObject);
            }
            objectArray = cmdOption.names();
            CmdOptionHandler cmdOptionHandler = this.findHandler(accessibleObject, cmdOption.args().length, cmdOption.handler());
            if (cmdOptionHandler == null) {
                object2 = this.i18n.preparetr("No suitable handler found for option(s): {0} ({1} argument(s))", FList.mkString(cmdOption.names(), ","), cmdOption.args().length);
                throw new CmdlineParserException(object2.notr(), object2.tr());
            }
            if (objectArray == null || objectArray.length == 0) {
                if (this.parameter.isDefined()) {
                    object2 = this.i18n.preparetr("More than one parameter definition found. First definition: {0} Second definition: {1}", this.parameter.get().getElement(), accessibleObject);
                    throw new CmdlineParserException(object2.notr(), object2.tr());
                }
                if (cmdOption.isHelp()) {
                    this.debug("Warning: Found annotation for the main parameter with enabled isHelp=true. The isHelp will be ignored.", new Object[0]);
                }
                if (cmdOption.maxCount() == 0) {
                    this.debug("Warning: Found annotation for the main parameter with maxCount=0. This is interpreted as unconstrained.", new Object[0]);
                }
                if (((OptionHandle)(object2 = new OptionHandle(new String[0], cmdOption.description(), cmdOptionHandler, object, accessibleObject, cmdOption.args(), cmdOption.minCount(), cmdOption.maxCount(), false, cmdOption.hidden(), cmdOption.requires(), cmdOption.conflictsWith()))).getArgsCount() <= 0) {
                    I18n.PreparedI18n preparedI18n = this.i18n.preparetr("Parameter definition must support at least on argument.", new Object[0]);
                    throw new CmdlineParserException(preparedI18n.notr(), preparedI18n.tr());
                }
                this.parameter = Optional.some(object2);
                continue;
            }
            if (cmdOption.maxCount() == 0) {
                this.debug("Warning: Found annotation for option [{0}] with maxCount=0. This is interpreted as unconstrained.", FList.mkString(objectArray, ","));
            }
            object2 = new OptionHandle((String[])objectArray, cmdOption.description(), cmdOptionHandler, object, accessibleObject, cmdOption.args(), cmdOption.minCount(), cmdOption.maxCount(), cmdOption.isHelp(), cmdOption.hidden(), cmdOption.requires(), cmdOption.conflictsWith());
            for (Object object3 : objectArray) {
                if (this.quickCommandMap.containsKey(object3) || this.quickOptionMap.containsKey(object3)) {
                    I18n.PreparedI18n preparedI18n = this.i18n.preparetr("Duplicate command/option name \"{0}\" found in: {1}", object3, accessibleObject);
                    throw new CmdlineParserException(preparedI18n.notr(), preparedI18n.tr());
                }
                this.quickOptionMap.put((String)object3, (OptionHandle)object2);
            }
            linkedList.add((OptionHandle)object2);
        }
        return linkedList;
    }

    public void unregisterAllHandler() {
        this.handlerRegistry.clear();
    }

    public void unregisterHandler(Class<? extends CmdOptionHandler> clazz) {
        if (clazz != null) {
            this.handlerRegistry.remove(clazz);
        }
    }

    public void registerHandler(CmdOptionHandler cmdOptionHandler) {
        if (cmdOptionHandler != null) {
            this.debug("Register CmdOptionHandler: {0}", cmdOptionHandler);
            this.handlerRegistry.put(cmdOptionHandler.getClass(), cmdOptionHandler);
        }
    }

    public void commandUsage(Class<?> clazz) {
        for (CommandHandle commandHandle : this.commands) {
            if (!commandHandle.getObject().getClass().equals(clazz)) continue;
            commandHandle.getCmdlineParser().usage();
            return;
        }
        throw new IllegalArgumentException("Given command is not known or does not have a @" + CmdCommand.class.getSimpleName() + "-annotation");
    }

    public void usage() {
        this.usage(System.out);
    }

    @Deprecated
    public void usage(StringBuilder stringBuilder) {
        stringBuilder.append(this.usageString());
    }

    public void usage(PrintStream printStream) {
        this.usageFormatter.format(printStream, this.getCmdlineModel());
    }

    public String usageString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        this.usage(printStream);
        printStream.flush();
        return new String(byteArrayOutputStream.toByteArray(), Charset.forName("UTF-8"));
    }

    public CmdlineModel getCmdlineModel() {
        String string = this.programName;
        if (this.parent != null) {
            string = this.parent.programName + " " + string;
        }
        return new CmdlineModel(string, this.options, this.commands, this.parameter.orNull(), this.aboutLine, this.resourceBundle);
    }

    public void setProgramName(String string) {
        this.programName = string;
    }

    public void setAboutLine(String string) {
        this.aboutLine = string;
    }

    public void setResourceBundle(String string, ClassLoader classLoader) {
        this.setResourceBundle(string, Locale.getDefault(), classLoader);
    }

    public void setResourceBundle(String string, Locale locale, ClassLoader classLoader) {
        try {
            this.resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
            this.debug("Loaded a ResourceBundle with name \"{0}\" using classloader \"{1}\". Locale: {2}", string, classLoader, this.resourceBundle.getLocale());
        }
        catch (MissingResourceException missingResourceException) {
            this.debug("Could not load a ResourceBundle with name \"{0}\" using classloader \"{1}\" for locale {2}", string, classLoader, Locale.getDefault());
            this.resourceBundle = null;
        }
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public void setReadArgsFromFilePrefix(String string) {
        this.argsFromFilePrefix = string == null || string.trim().isEmpty() ? Optional.none() : Optional.some(string.trim());
    }

    public void setAggregateShortOptionsWithPrefix(String string) {
        this.aggregateShortOptionsWithPrefix = string == null || string.trim().isEmpty() ? Optional.none() : Optional.some(string.trim());
    }

    public void setShortOptionWithArgsPrefix(String string) {
        this.shortOptionsWithArgsPrefix = string == null || string.trim().isEmpty() ? Optional.none() : Optional.some(string.trim());
    }
}

