/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.internal;

import de.tototec.cmdoption.internal.I18n;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class I18nFactory {
    public static I18n getI18n(Class<?> clazz) {
        return I18nFactory.getI18n(clazz, Locale.getDefault());
    }

    public static I18n getI18n(final Class<?> clazz, final Locale locale) {
        return new I18n(){

            @Override
            public String trn(String string, String string2, long l, Object ... objectArray) {
                String string3 = l == 1L ? string : string2;
                return this.tr(string3, objectArray);
            }

            @Override
            public String trcn(String string, String string2, String string3, long l, Object ... objectArray) {
                return this.trn(string2, string3, l, objectArray);
            }

            @Override
            public String trc(String string, String string2, Object ... objectArray) {
                return this.tr(string2, objectArray);
            }

            @Override
            public String tr(String string, Object ... objectArray) {
                String string2;
                try {
                    string2 = ResourceBundle.getBundle(clazz.getPackage().getName() + ".Messages", locale, clazz.getClassLoader()).getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    string2 = string;
                }
                return objectArray == null || objectArray.length == 0 ? string2 : MessageFormat.format(string2, objectArray);
            }

            @Override
            public I18n.PreparedI18n preparetr(final String string, final Object ... objectArray) {
                final 1 var3_3 = this;
                return new I18n.PreparedI18n(){

                    @Override
                    public String tr() {
                        return var3_3.tr(string, objectArray);
                    }

                    @Override
                    public String notr() {
                        if (objectArray != null && objectArray.length > 0) {
                            return MessageFormat.format(string, objectArray);
                        }
                        return string;
                    }
                };
            }

            @Override
            public Locale getLocale() {
                return locale;
            }
        };
    }
}

