/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.internal;

import de.tototec.cmdoption.internal.F1;
import de.tototec.cmdoption.internal.F2;
import de.tototec.cmdoption.internal.Optional;
import de.tototec.cmdoption.internal.Procedure1;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class FList {
    public static <T> List<T> distinct(Iterable<T> iterable) {
        LinkedList<T> linkedList = new LinkedList<T>();
        for (T t : iterable) {
            if (linkedList.contains(iterable)) continue;
            linkedList.add(t);
        }
        return linkedList;
    }

    public static <T> List<T> distinct(T[] TArray) {
        return FList.distinct(Arrays.asList(TArray));
    }

    public static <T> List<T> dropWhile(Iterable<T> iterable, F1<? super T, Boolean> f1) {
        LinkedList<T> linkedList = new LinkedList<T>();
        boolean bl = true;
        for (T t : iterable) {
            if (bl && !f1.apply(t).booleanValue()) {
                bl = false;
            }
            if (bl) continue;
            linkedList.add(t);
        }
        return linkedList;
    }

    public static <T> List<T> dropWhile(T[] TArray, F1<? super T, Boolean> f1) {
        return FList.dropWhile(Arrays.asList(TArray), f1);
    }

    public static <T> boolean exists(Iterable<T> iterable, F1<? super T, Boolean> f1) {
        for (T t : iterable) {
            if (!f1.apply(t).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean exists(T[] TArray, F1<? super T, Boolean> f1) {
        return FList.exists(Arrays.asList(TArray), f1);
    }

    public static <T> List<T> filter(Iterable<T> iterable, F1<? super T, Boolean> f1) {
        LinkedList<T> linkedList = new LinkedList<T>();
        for (T t : iterable) {
            if (!f1.apply(t).booleanValue()) continue;
            linkedList.add(t);
        }
        return linkedList;
    }

    public static <T> List<T> filter(T[] TArray, F1<? super T, Boolean> f1) {
        return FList.filter(Arrays.asList(TArray), f1);
    }

    public static <T> List<T> filterType(Iterable<?> iterable, Class<T> clazz) {
        LinkedList linkedList = new LinkedList();
        for (Object obj : iterable) {
            if (obj == null || !clazz.isAssignableFrom(obj.getClass())) continue;
            Object obj2 = obj;
            linkedList.add(obj2);
        }
        return linkedList;
    }

    public static <T> List<T> filterType(Object[] objectArray, Class<T> clazz) {
        return FList.filterType(Arrays.asList(objectArray), clazz);
    }

    public static <T> Optional<T> find(Iterable<T> iterable, F1<? super T, Boolean> f1) {
        for (T t : iterable) {
            if (!f1.apply(t).booleanValue()) continue;
            return Optional.some(t);
        }
        return Optional.none();
    }

    public static <T> Optional<T> find(T[] TArray, F1<? super T, Boolean> f1) {
        return FList.find(Arrays.asList(TArray), f1);
    }

    public static <T, R> List<R> flatMap(Iterable<T> iterable, F1<? super T, ? extends Iterable<R>> f1) {
        AbstractList abstractList = iterable instanceof Collection ? new ArrayList(((Collection)iterable).size()) : new LinkedList();
        for (T t : iterable) {
            Iterable<R> iterable2 = f1.apply(t);
            if (iterable2 instanceof Collection) {
                abstractList.addAll((Collection)iterable2);
                continue;
            }
            for (R r : iterable2) {
                abstractList.add(r);
            }
        }
        return abstractList;
    }

    public static <T, R> List<R> flatMap(T[] TArray, F1<? super T, ? extends Iterable<R>> f1) {
        return FList.flatMap(Arrays.asList(TArray), f1);
    }

    public static <T> List<T> flatten(Iterable<Iterable<T>> iterable) {
        LinkedList<T> linkedList = new LinkedList<T>();
        for (Iterable<T> iterable2 : iterable) {
            if (iterable2 instanceof Collection) {
                linkedList.addAll((Collection)iterable2);
                continue;
            }
            for (T t : iterable2) {
                linkedList.add(t);
            }
        }
        return linkedList;
    }

    public static <T> List<T> flatten(Iterable<T>[] iterableArray) {
        return FList.flatten(Arrays.asList(iterableArray));
    }

    public static <T> List<T> flatten(T[][] TArray) {
        LinkedList<T> linkedList = new LinkedList<T>();
        T[][] TArray2 = TArray;
        int n = TArray2.length;
        for (int i = 0; i < n; ++i) {
            T[] TArray3;
            for (T t : TArray3 = TArray2[i]) {
                linkedList.add(t);
            }
        }
        return linkedList;
    }

    public static <T, R> R foldLeft(Iterable<T> iterable, R r, F2<R, ? super T, R> f2) {
        R r2 = r;
        for (T t : iterable) {
            r2 = f2.apply(r2, t);
        }
        return r2;
    }

    public static <T, R> R foldLeft(T[] TArray, R r, F2<R, ? super T, R> f2) {
        return FList.foldLeft(Arrays.asList(TArray), r, f2);
    }

    public static <T, R> R foldRight(Iterable<T> iterable, F2<? super T, R, R> f2, R r) {
        List<R> list = iterable instanceof List ? (List<R>)iterable : FList.map(iterable, new F1.Identity());
        R r2 = r;
        for (int i = list.size() - 1; i >= 0; --i) {
            r2 = f2.apply(list.get(i), r2);
        }
        return r2;
    }

    public static <T, R> R foldRight(T[] TArray, F2<? super T, R, R> f2, R r) {
        R r2 = r;
        for (int i = TArray.length - 1; i >= 0; --i) {
            r2 = f2.apply(TArray[i], r2);
        }
        return r2;
    }

    public static <T> boolean forall(Iterable<T> iterable, F1<? super T, Boolean> f1) {
        for (T t : iterable) {
            if (f1.apply(t).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean forall(T[] TArray, F1<? super T, Boolean> f1) {
        return FList.forall(Arrays.asList(TArray), f1);
    }

    public static <T> void foreach(Iterable<T> iterable, Procedure1<? super T> procedure1) {
        for (T t : iterable) {
            procedure1.apply(t);
        }
    }

    public static <T> void foreach(T[] TArray, Procedure1<? super T> procedure1) {
        FList.foreach(Arrays.asList(TArray), procedure1);
    }

    public static <T, K> Map<K, List<T>> groupBy(T[] TArray, F1<? super T, ? extends K> f1) {
        return FList.groupBy(Arrays.asList(TArray), f1);
    }

    public static <T, K> Map<K, List<T>> groupBy(Iterable<T> iterable, F1<? super T, ? extends K> f1) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (T t : iterable) {
            List<T> list;
            K k = f1.apply(t);
            if (linkedHashMap.containsKey(k)) {
                list = (List)linkedHashMap.get(k);
            } else {
                list = new LinkedList();
                linkedHashMap.put(k, list);
            }
            list.add(t);
        }
        return linkedHashMap;
    }

    public static <T, R> List<R> map(Iterable<T> iterable, F1<? super T, ? extends R> f1) {
        AbstractList abstractList = iterable instanceof Collection ? new ArrayList(((Collection)iterable).size()) : new LinkedList();
        for (T t : iterable) {
            abstractList.add(f1.apply(t));
        }
        return abstractList;
    }

    public static <T, R> List<R> map(T[] TArray, F1<? super T, ? extends R> f1) {
        return FList.map(Arrays.asList(TArray), f1);
    }

    public static String mkString(Iterable<?> iterable, String string) {
        return FList.mkString(iterable, null, string, null);
    }

    public static String mkString(Object[] objectArray, String string) {
        return FList.mkString(Arrays.asList(objectArray), string);
    }

    public static String mkString(Iterable<?> iterable, String string, String string2, String string3) {
        return FList.mkString(iterable, string, string2, string3, null);
    }

    public static <T> String mkString(T[] TArray, String string, String string2, String string3) {
        return FList.mkString(Arrays.asList(TArray), string, string2, string3);
    }

    public static <T> String mkString(Iterable<T> iterable, String string, String string2, String string3, F1<? super T, String> f1) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
        }
        boolean bl = false;
        for (T t : iterable) {
            if (bl && string2 != null) {
                stringBuilder.append(string2);
            }
            bl = true;
            if (f1 != null) {
                stringBuilder.append(f1.apply(t));
                continue;
            }
            stringBuilder.append(t == null ? null : t.toString());
        }
        if (string3 != null) {
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    public static <T> String mkString(T[] TArray, String string, String string2, String string3, F1<? super T, String> f1) {
        return FList.mkString(Arrays.asList(TArray), string, string2, string3, f1);
    }

    public static <T> List<T> reverse(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            ArrayList arrayList = new ArrayList((Collection)iterable);
            Collections.reverse(arrayList);
            return arrayList;
        }
        LinkedList<T> linkedList = new LinkedList<T>();
        for (T t : iterable) {
            linkedList.add(0, t);
        }
        return linkedList;
    }

    public static <T> List<T> reverse(T[] TArray) {
        return FList.reverse(Arrays.asList(TArray));
    }

    public static <T> List<T> sort(Iterable<T> iterable, Comparator<? super T> comparator) {
        ArrayList<T> arrayList;
        if (iterable instanceof Collection) {
            arrayList = new ArrayList((Collection)iterable);
        } else {
            arrayList = new ArrayList<T>();
            for (T t : iterable) {
                arrayList.add(t);
            }
        }
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public static <T> List<T> sort(T[] TArray, Comparator<? super T> comparator) {
        return FList.sort(Arrays.asList(TArray), comparator);
    }

    public static <T, C extends Comparable<C>> List<T> sortWith(Iterable<T> iterable, final F1<? super T, C> f1) {
        return FList.sort(iterable, new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                return ((Comparable)f1.apply(t)).compareTo(f1.apply(t2));
            }
        });
    }

    public static <T, C extends Comparable<C>> List<T> sortWith(T[] TArray, F1<? super T, C> f1) {
        return FList.sortWith(Arrays.asList(TArray), f1);
    }

    public static <T> List<T> takeWhile(Iterable<T> iterable, F1<? super T, Boolean> f1) {
        LinkedList<T> linkedList = new LinkedList<T>();
        for (T t : iterable) {
            if (!f1.apply(t).booleanValue()) break;
            linkedList.add(t);
        }
        return linkedList;
    }

    public static <T> List<T> takeWhile(T[] TArray, F1<? super T, Boolean> f1) {
        return FList.takeWhile(Arrays.asList(TArray), f1);
    }

    private FList() {
    }
}

