/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.handler;

import de.tototec.cmdoption.handler.CmdOptionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandlerException;
import de.tototec.cmdoption.internal.I18n;
import de.tototec.cmdoption.internal.I18nFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;

public class UrlHandler
implements CmdOptionHandler {
    @Override
    public boolean canHandle(AccessibleObject accessibleObject, int n) {
        if (n == 1) {
            if (accessibleObject instanceof Field) {
                Field field = (Field)accessibleObject;
                return !Modifier.isFinal(field.getModifiers()) && field.getType().equals(URL.class);
            }
            if (accessibleObject instanceof Method) {
                Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
                return classArray.length == 1 && classArray[0].equals(URL.class);
            }
        }
        return false;
    }

    @Override
    public void applyParams(Object object, AccessibleObject accessibleObject, String[] stringArray, String string) throws CmdOptionHandlerException {
        try {
            URL uRL = new URL(stringArray[0]);
            if (accessibleObject instanceof Field) {
                ((Field)accessibleObject).set(object, uRL);
            } else if (accessibleObject instanceof Method) {
                ((Method)accessibleObject).invoke(object, uRL);
            }
        }
        catch (MalformedURLException malformedURLException) {
            I18n i18n = I18nFactory.getI18n(UrlHandler.class);
            I18n.PreparedI18n preparedI18n = i18n.preparetr("Invalid url: \"{0}\"", stringArray[0]);
            throw new CmdOptionHandlerException(preparedI18n.notr(), malformedURLException, preparedI18n.tr());
        }
        catch (Exception exception) {
            I18n i18n = I18nFactory.getI18n(UrlHandler.class);
            I18n.PreparedI18n preparedI18n = i18n.preparetr("Could not apply parameters: {0} to field/method {1}", Arrays.toString(stringArray), accessibleObject);
            throw new CmdOptionHandlerException(preparedI18n.notr(), exception, preparedI18n.tr());
        }
    }
}

