/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.handler;

import de.tototec.cmdoption.handler.CmdOptionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandlerException;
import de.tototec.cmdoption.internal.I18n;
import de.tototec.cmdoption.internal.I18nFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;

public class StringMethodHandler
implements CmdOptionHandler {
    @Override
    public boolean canHandle(AccessibleObject accessibleObject, int n) {
        Method method;
        if (accessibleObject instanceof Method && (method = (Method)accessibleObject).getParameterTypes().length == n) {
            boolean bl = true;
            for (Class<?> clazz : method.getParameterTypes()) {
                bl &= String.class.isAssignableFrom(clazz);
            }
            return bl;
        }
        return false;
    }

    @Override
    public void applyParams(Object object, AccessibleObject accessibleObject, String[] stringArray, String string) throws CmdOptionHandlerException {
        try {
            Method method = (Method)accessibleObject;
            method.invoke(object, (Object[])stringArray);
        }
        catch (Exception exception) {
            I18n i18n = I18nFactory.getI18n(StringMethodHandler.class);
            I18n.PreparedI18n preparedI18n = i18n.preparetr("Could not apply parameters: {0} to method {1}", Arrays.toString(stringArray), accessibleObject);
            throw new CmdOptionHandlerException(preparedI18n.notr(), exception, preparedI18n.tr());
        }
    }
}

