/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.handler;

import de.tototec.cmdoption.handler.CmdOptionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandlerException;
import de.tototec.cmdoption.internal.I18n;
import de.tototec.cmdoption.internal.I18nFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public class StringFieldHandler
implements CmdOptionHandler {
    @Override
    public boolean canHandle(AccessibleObject accessibleObject, int n) {
        if (accessibleObject instanceof Field && n == 1) {
            Field field = (Field)accessibleObject;
            return !Modifier.isFinal(field.getModifiers()) && field.getType().equals(String.class);
        }
        return false;
    }

    @Override
    public void applyParams(Object object, AccessibleObject accessibleObject, String[] stringArray, String string) throws CmdOptionHandlerException {
        try {
            Field field = (Field)accessibleObject;
            field.set(object, stringArray[0]);
        }
        catch (Exception exception) {
            I18n i18n = I18nFactory.getI18n(StringFieldHandler.class);
            I18n.PreparedI18n preparedI18n = i18n.preparetr("Could not apply parameters: {0} to field {1}", Arrays.toString(stringArray), accessibleObject);
            throw new CmdOptionHandlerException(preparedI18n.notr(), exception, preparedI18n.tr());
        }
    }
}

