/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.handler;

import de.tototec.cmdoption.handler.CmdOptionHandler;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class BooleanOptionHandler
implements CmdOptionHandler {
    @Override
    public void applyParams(Object object, AccessibleObject accessibleObject, String[] stringArray, String string) {
        try {
            if (accessibleObject instanceof Field) {
                Field field = (Field)accessibleObject;
                field.set(object, true);
            } else {
                Method method = (Method)accessibleObject;
                if (method.getParameterTypes().length == 1) {
                    method.invoke(object, true);
                } else {
                    method.invoke(object, new Object[0]);
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean canHandle(AccessibleObject accessibleObject, int n) {
        if (n != 0) {
            return false;
        }
        if (accessibleObject instanceof Field) {
            Field field = (Field)accessibleObject;
            Class<?> clazz = field.getType();
            return !Modifier.isFinal(field.getModifiers()) && (Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz));
        }
        if (accessibleObject instanceof Method) {
            Method method = (Method)accessibleObject;
            if (method.getParameterTypes().length == 0) {
                return true;
            }
            if (method.getParameterTypes().length == 1) {
                Class<?> clazz = method.getParameterTypes()[0];
                return Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz);
            }
        }
        return false;
    }
}

