/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption;

import de.tototec.cmdoption.handler.CmdOptionHandler;
import de.tototec.cmdoption.internal.FList;
import java.lang.reflect.AccessibleObject;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OptionHandle {
    private final String[] names;
    private final String description;
    private final CmdOptionHandler cmdOptionHandler;
    private final AccessibleObject element;
    private final String[] args;
    private final int minCount;
    private final int maxCount;
    private final boolean help;
    private final Object object;
    private final boolean hidden;
    private String[] requires;
    private String[] conflictsWith;

    public OptionHandle(String[] stringArray, String string, CmdOptionHandler cmdOptionHandler, Object object, AccessibleObject accessibleObject, String[] stringArray2, int n, int n2, boolean bl, boolean bl2, String[] stringArray3, String[] stringArray4) {
        this.names = stringArray;
        this.description = string;
        this.cmdOptionHandler = cmdOptionHandler;
        this.object = object;
        this.element = accessibleObject;
        this.args = stringArray2;
        this.minCount = n;
        this.maxCount = n2;
        this.help = bl;
        this.hidden = bl2;
        this.requires = stringArray3;
        this.conflictsWith = stringArray4;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getDescription() {
        return this.description;
    }

    public CmdOptionHandler getCmdOptionHandler() {
        return this.cmdOptionHandler;
    }

    public String[] getArgs() {
        return this.args;
    }

    public int getArgsCount() {
        return this.args == null ? 0 : this.args.length;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public Object getObject() {
        return this.object;
    }

    public AccessibleObject getElement() {
        return this.element;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isHelp() {
        return this.help;
    }

    public String[] getRequires() {
        return this.requires;
    }

    public String[] getConflictsWith() {
        return this.conflictsWith;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(names=" + FList.mkString(this.getNames(), ",") + ",args=" + FList.mkString(this.getArgs(), ",") + ",minCount=" + this.getMinCount() + ",maxCount=" + this.getMaxCount() + ",description=" + this.getDescription() + ",requires=" + FList.mkString(this.getRequires(), ",") + ",conflictsWith=" + FList.mkString(this.getConflictsWith(), ",") + ",isHidden=" + this.isHidden() + ",isHelp=" + this.isHelp() + ",handler=" + this.getCmdOptionHandler().getClass().getName() + ")";
    }

    public static class OptionHandleComparator
    implements Comparator<OptionHandle> {
        @Override
        public int compare(OptionHandle optionHandle, OptionHandle optionHandle2) {
            return this.sanitizeString(optionHandle.getNames()[0]).compareTo(this.sanitizeString(optionHandle2.getNames()[0]));
        }

        public String sanitizeString(String string) {
            Pattern pattern = Pattern.compile("^[^A-Za-z0-9]*(.*)$");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return string;
        }
    }
}

