/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption;

import de.tototec.cmdoption.CmdlineModel;
import de.tototec.cmdoption.CommandHandle;
import de.tototec.cmdoption.LineLengthDetector;
import de.tototec.cmdoption.OptionHandle;
import de.tototec.cmdoption.UsageFormatter2;
import de.tototec.cmdoption.internal.FList;
import de.tototec.cmdoption.internal.I18n;
import de.tototec.cmdoption.internal.I18nFactory;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DefaultUsageFormatter2
implements UsageFormatter2 {
    private final I18n i18n = I18nFactory.getI18n(DefaultUsageFormatter2.class);
    private final boolean withCommandDetails;
    private int lineLength;
    private int colSpace = 2;
    private int col1Prefix = 2;
    private volatile LineLengthDetector lineLengthDetector;

    public DefaultUsageFormatter2(boolean bl, int n, LineLengthDetector lineLengthDetector) {
        this.withCommandDetails = bl;
        this.lineLengthDetector = lineLengthDetector;
        this.lineLength = n;
    }

    public DefaultUsageFormatter2(boolean bl, int n) {
        this(bl, n, null);
    }

    public DefaultUsageFormatter2(boolean bl) {
        this(bl, 80, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getLineLength() {
        if (this.lineLengthDetector != null) {
            DefaultUsageFormatter2 defaultUsageFormatter2 = this;
            synchronized (defaultUsageFormatter2) {
                if (this.lineLengthDetector != null) {
                    Integer n = this.lineLengthDetector.detectOrNull();
                    if (n != null) {
                        this.lineLength = n;
                    }
                    this.lineLengthDetector = null;
                }
            }
        }
        return this.lineLength;
    }

    protected String translate(ResourceBundle resourceBundle, String string) {
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string;
    }

    protected String[] translate(ResourceBundle resourceBundle, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.translate(resourceBundle, stringArray[i]);
        }
        return stringArray2;
    }

    @Override
    public void format(PrintStream printStream, CmdlineModel cmdlineModel) {
        Object object;
        Object object2;
        ArrayList<OptionHandle> arrayList = new ArrayList<OptionHandle>(cmdlineModel.getOptions());
        Object object3 = arrayList.iterator();
        while (object3.hasNext()) {
            if (!object3.next().isHidden()) continue;
            object3.remove();
        }
        Collections.sort(arrayList, new OptionHandle.OptionHandleComparator());
        object3 = new ArrayList<CommandHandle>(cmdlineModel.getCommands());
        Iterator iterator = ((ArrayList)object3).iterator();
        while (iterator.hasNext()) {
            if (!((CommandHandle)iterator.next()).isHidden()) continue;
            iterator.remove();
        }
        Collections.sort(object3, new CommandHandle.CommandHandleComparator());
        if (cmdlineModel.getAboutLine() != null && cmdlineModel.getAboutLine().length() > 0) {
            printStream.append(this.translate(cmdlineModel.getResourceBundle(), cmdlineModel.getAboutLine())).append("\n\n");
        }
        printStream.append(this.i18n.tr("Usage:", new Object[0])).append(" ");
        printStream.append(cmdlineModel.getProgramName() == null ? this.i18n.tr("program", new Object[0]) : cmdlineModel.getProgramName());
        if (!arrayList.isEmpty()) {
            printStream.append(" ").append(this.i18n.tr("[options]", new Object[0]));
        }
        if (cmdlineModel.getParameter() != null) {
            printStream.append(" ").append(this.i18n.tr("[parameter]", new Object[0]));
        }
        if (!((ArrayList)object3).isEmpty()) {
            printStream.append(" ").append(this.i18n.tr("[command]", new Object[0]));
            boolean bl = false;
            boolean bl2 = false;
            object2 = ((ArrayList)object3).iterator();
            while (object2.hasNext()) {
                object = (CommandHandle)object2.next();
                bl |= !((CommandHandle)object).getCmdlineParser().getCmdlineModel().getOptions().isEmpty();
                bl2 |= ((CommandHandle)object).getCmdlineParser().getCmdlineModel().getParameter() != null;
            }
            if (bl) {
                printStream.append(" ").append(this.i18n.tr("[command options]", new Object[0]));
            }
            if (bl2) {
                printStream.append(" ").append(this.i18n.tr("[command parameters]", new Object[0]));
            }
        }
        printStream.append("\n");
        this.formatOptions(printStream, arrayList, "\n" + this.i18n.tr("Options:", new Object[0]), cmdlineModel.getResourceBundle());
        this.formatCommands(printStream, (List<CommandHandle>)object3, "\n" + this.i18n.tr("Commands:", new Object[0]), cmdlineModel.getResourceBundle());
        if (this.withCommandDetails) {
            iterator = ((ArrayList)object3).iterator();
            while (iterator.hasNext()) {
                CommandHandle commandHandle = (CommandHandle)iterator.next();
                object2 = new ArrayList<OptionHandle>(commandHandle.getCmdlineParser().getCmdlineModel().getOptions());
                object = ((ArrayList)object2).iterator();
                while (object.hasNext()) {
                    if (!((OptionHandle)object.next()).isHidden()) continue;
                    object.remove();
                }
                Collections.sort(object2, new OptionHandle.OptionHandleComparator());
                this.formatOptions(printStream, (List<OptionHandle>)object2, "\n" + this.i18n.tr("Options for command:", new Object[0]) + " " + FList.mkString(commandHandle.getNames(), ", "), cmdlineModel.getResourceBundle());
                this.formatParameter(printStream, commandHandle.getCmdlineParser().getCmdlineModel().getParameter(), "\n" + this.i18n.tr("Parameter for command:", new Object[0]) + " " + FList.mkString(commandHandle.getNames(), ", "), cmdlineModel.getResourceBundle());
            }
        }
        this.formatParameter(printStream, cmdlineModel.getParameter(), "\n" + this.i18n.tr("Parameter:", new Object[0]), cmdlineModel.getResourceBundle());
    }

    protected void formatParameter(PrintStream printStream, OptionHandle optionHandle, String string, ResourceBundle resourceBundle) {
        if (optionHandle == null) {
            return;
        }
        printStream.append(string).append("\n");
        DefaultUsageFormatter2.mkSpace(printStream, this.col1Prefix);
        Object[] objectArray = this.translate(resourceBundle, optionHandle.getArgs());
        printStream.append(FList.mkString(objectArray, " "));
        if (optionHandle.getDescription() != null) {
            DefaultUsageFormatter2.mkSpace(printStream, this.colSpace);
            printStream.append(MessageFormat.format(this.translate(resourceBundle, optionHandle.getDescription()), objectArray));
        }
        printStream.append("\n");
    }

    protected void formatOptions(PrintStream printStream, List<OptionHandle> list, String string, ResourceBundle resourceBundle) {
        if (list == null || list.isEmpty()) {
            return;
        }
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        boolean bl = false;
        for (OptionHandle optionHandle : list) {
            if (optionHandle.isHidden()) continue;
            bl = true;
            String string2 = FList.mkString(optionHandle.getNames(), ",");
            Object[] objectArray = this.translate(resourceBundle, optionHandle.getArgs());
            String string3 = FList.mkString(objectArray, " ");
            linkedList.add(new String[]{string2 + (string3.length() == 0 ? "" : " " + string3), MessageFormat.format(this.translate(resourceBundle, optionHandle.getDescription()), objectArray)});
        }
        if (!bl) {
            return;
        }
        if (string != null) {
            printStream.append(string).append("\n");
        }
        DefaultUsageFormatter2.formatTable(printStream, linkedList, this.col1Prefix, this.colSpace, this.getLineLength());
    }

    protected void formatCommands(PrintStream printStream, List<CommandHandle> list, String string, ResourceBundle resourceBundle) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (string != null) {
            printStream.append(string).append("\n");
        }
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        for (CommandHandle commandHandle : list) {
            String string2 = FList.mkString(commandHandle.getNames(), ",");
            linkedList.add(new String[]{string2, this.translate(resourceBundle, commandHandle.getDescription())});
        }
        DefaultUsageFormatter2.formatTable(printStream, linkedList, this.col1Prefix, this.colSpace, this.getLineLength());
    }

    public static void mkSpace(PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            printStream.append(" ");
        }
    }

    public static void formatTable(PrintStream printStream, List<String[]> list, int n, int n2, int n3) {
        int n4 = 2;
        for (String[] object : list) {
            if (object.length <= 0 || object[0] == null) continue;
            n4 = Math.max(n4, object[0].length());
        }
        boolean bl = n + n2 + n4 + 10 > n3;
        for (String[] stringArray : list) {
            if (stringArray.length > 0) {
                DefaultUsageFormatter2.mkSpace(printStream, n);
                int n5 = n;
                if (stringArray[0] != null) {
                    printStream.append(stringArray[0]);
                    n5 += stringArray[0].length();
                }
                if (bl) {
                    printStream.append("\n");
                } else {
                    DefaultUsageFormatter2.mkSpace(printStream, n + n4 + n2 - n5);
                }
                if (stringArray[1] != null) {
                    if (bl) {
                        DefaultUsageFormatter2.wrap(printStream, stringArray[1], n + n2, n3 - n - n2);
                    } else {
                        DefaultUsageFormatter2.wrap(printStream, stringArray[1], n + n2 + n4, n3 - n - n2 - n4);
                    }
                }
            }
            printStream.append("\n");
        }
    }

    public static void wrap(PrintStream printStream, String string, int n, int n2) {
        int n3 = Math.max(n2, 0);
        if ((string = string.trim()).length() <= n3) {
            printStream.append(string);
        } else {
            int n4 = -1;
            n4 = " ".equals(string.substring(n3, n3 + 1)) ? n3 : string.substring(0, n3).lastIndexOf(" ");
            if (n4 == -1) {
                n4 = string.indexOf(" ");
            }
            if (n4 > 0) {
                printStream.append(string.substring(0, n4)).append("\n");
                for (int i = 0; i < n; ++i) {
                    printStream.append(" ");
                }
                DefaultUsageFormatter2.wrap(printStream, string.substring(n4), n, n3);
            } else {
                printStream.append(string);
            }
        }
    }
}

