/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption;

import de.tototec.cmdoption.CmdlineModel;
import de.tototec.cmdoption.CmdlineParser;
import de.tototec.cmdoption.internal.FList;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandHandle {
    private final String[] names;
    private final String description;
    private final CmdlineParser cmdlineParser;
    private final Object object;
    private final boolean hidden;

    public CommandHandle(String[] stringArray, String string, CmdlineParser cmdlineParser, Object object, boolean bl) {
        this.names = stringArray;
        this.description = string;
        this.cmdlineParser = cmdlineParser;
        this.object = object;
        this.hidden = bl;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getDescription() {
        return this.description;
    }

    public CmdlineParser getCmdlineParser() {
        return this.cmdlineParser;
    }

    public CmdlineModel getCommandCmdlineModel() {
        return this.cmdlineParser.getCmdlineModel();
    }

    public Object getObject() {
        return this.object;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(names=" + FList.mkString(this.names, ",") + ",description=" + this.description + ",cmdlineParser=" + this.cmdlineParser + ",object=" + this.object + ",hidden=" + this.hidden + ")";
    }

    public static class CommandHandleComparator
    implements Comparator<CommandHandle> {
        @Override
        public int compare(CommandHandle commandHandle, CommandHandle commandHandle2) {
            return this.sanitizeString(commandHandle.getNames()[0]).compareTo(this.sanitizeString(commandHandle2.getNames()[0]));
        }

        public String sanitizeString(String string) {
            Pattern pattern = Pattern.compile("^[^A-Za-z0-9]*(.*)$");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return string;
        }
    }
}

