/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.hrx;

import de.topobyte.hrx.Line;
import de.topobyte.hrx.LineTerminator;
import java.io.IOException;
import java.io.Reader;

class LineReader {
    private Reader br;

    public LineReader(Reader br) {
        this.br = br;
    }

    public Line readLine() throws IOException {
        StringBuilder buffer = new StringBuilder();
        LineTerminator terminator = LineTerminator.EOF;
        while (true) {
            int r;
            if ((r = this.br.read()) == -1) {
                terminator = LineTerminator.EOF;
                break;
            }
            char c = (char)r;
            if (c == '\n') {
                terminator = LineTerminator.UNIX;
                int len = buffer.length();
                if (len <= 0 || buffer.charAt(len - 1) != '\r') break;
                terminator = LineTerminator.WINDOWS;
                break;
            }
            buffer.append(c);
        }
        if (terminator == LineTerminator.EOF && buffer.length() == 0) {
            return new Line(null, terminator);
        }
        return new Line(buffer.toString(), terminator);
    }
}

