/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.hrx;

import de.topobyte.hrx.HrxEntryType;
import de.topobyte.hrx.HrxException;
import de.topobyte.hrx.HrxFile;
import de.topobyte.hrx.HrxFiles;
import de.topobyte.hrx.Line;
import de.topobyte.hrx.LineReader;
import de.topobyte.hrx.LineSupplier;
import de.topobyte.hrx.Lines;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class HrxReader {
    private int boundaryLen;
    private String boundary;

    public List<HrxFile> read(Reader reader) throws IOException, HrxException {
        BufferedReader br = new BufferedReader(reader);
        return this.read(new LineReader(br));
    }

    public List<HrxFile> read(BufferedReader reader) throws IOException, HrxException {
        return this.read(new LineReader(reader));
    }

    List<HrxFile> read(LineReader br) throws IOException, HrxException {
        HrxFile file;
        ArrayList<HrxFile> results = new ArrayList<HrxFile>();
        Line line = br.readLine();
        this.boundaryLen = this.readFirstBoundary(line);
        this.boundary = this.boundary();
        LineSupplier supplier = new LineSupplier(br);
        supplier.push(line);
        while ((file = this.readEntry(supplier)) != null) {
            results.add(file);
        }
        return results;
    }

    private String boundary() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('<');
        for (int i = 0; i < this.boundaryLen; ++i) {
            buffer.append("=");
        }
        buffer.append('>');
        return buffer.toString();
    }

    private HrxFile readEntry(LineSupplier supplier) throws IOException, HrxException {
        Line line = supplier.next();
        if (line.isEOF()) {
            return null;
        }
        HrxEntryType type = this.readType(line);
        if (type == HrxEntryType.COMMENT) {
            Lines lines = this.readLines(supplier);
            return HrxFiles.comment(lines);
        }
        if (type == HrxEntryType.FILE) {
            String filename = this.readFilename(line);
            Lines lines = this.readLines(supplier);
            return HrxFiles.file(filename, lines);
        }
        if (type == HrxEntryType.DIRECTORY) {
            String dirname = this.readDirname(line);
            Lines lines = this.readLines(supplier);
            return HrxFiles.directory(dirname, lines);
        }
        throw new HrxException("invalid entry type");
    }

    private Lines readLines(LineSupplier supplier) throws IOException {
        boolean foundNext = false;
        Lines lines = new Lines();
        while (true) {
            Line line;
            if ((line = supplier.next()).isEOF()) {
                lines.append(line);
                break;
            }
            if (line.getContent().startsWith(this.boundary)) {
                supplier.push(line);
                foundNext = true;
                break;
            }
            lines.append(line);
        }
        if (foundNext) {
            lines.setLastToEof();
        }
        return lines;
    }

    private int readFirstBoundary(Line l) throws HrxException {
        char c;
        String line = l.getContent();
        int len = line.length();
        if (len < 3) {
            throw new HrxException("boundary too short");
        }
        int p = 0;
        int n = 0;
        if ((c = line.charAt(p++)) != '<') {
            throw new HrxException("expected '<'");
        }
        if ((c = line.charAt(p++)) != '=') {
            throw new HrxException("expected '<'");
        }
        ++n;
        while (p < len) {
            if ((c = line.charAt(p++)) == '=') {
                ++n;
                continue;
            }
            if (c != '>') continue;
            return n;
        }
        return 0;
    }

    private HrxEntryType readType(Line l) throws HrxException {
        char c;
        String line = l.getContent();
        int len = line.length();
        if (len == this.boundaryLen + 2) {
            return HrxEntryType.COMMENT;
        }
        int p = this.boundaryLen + 2;
        if ((c = line.charAt(p++)) != ' ') {
            throw new HrxException("expected ' '");
        }
        int remaining = len - p;
        char last = line.charAt(line.length() - 1);
        if (last == '/') {
            if (remaining > 1) {
                return HrxEntryType.DIRECTORY;
            }
            throw new HrxException("empty directory name is invalid");
        }
        if (remaining > 0) {
            return HrxEntryType.FILE;
        }
        throw new HrxException("empty directory name is invalid");
    }

    private String readFilename(Line line) {
        return line.getContent().substring(this.boundaryLen + 3);
    }

    private String readDirname(Line line) {
        return line.getContent().substring(this.boundaryLen + 3);
    }
}

