/*
 * Decompiled with CFR 0.152.
 */
package de.tomgrill.gdxfacebook.iosmoe;

import apple.foundation.NSArray;
import apple.foundation.NSDictionary;
import apple.foundation.NSError;
import apple.foundation.NSMutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.iosmoe.IOSApplication;
import com.badlogic.gdx.utils.Array;
import de.tomgrill.gdxfacebook.core.GDXFacebookAccessToken;
import de.tomgrill.gdxfacebook.core.GDXFacebookBasic;
import de.tomgrill.gdxfacebook.core.GDXFacebookCallback;
import de.tomgrill.gdxfacebook.core.GDXFacebookConfig;
import de.tomgrill.gdxfacebook.core.GDXFacebookError;
import de.tomgrill.gdxfacebook.core.GDXFacebookGameRequest;
import de.tomgrill.gdxfacebook.core.GameRequestResult;
import de.tomgrill.gdxfacebook.core.Result;
import de.tomgrill.gdxfacebook.core.SignInMode;
import de.tomgrill.gdxfacebook.core.SignInResult;
import de.tomgrill.gdxfacebook.iosmoe.bindings.sdk.core.fbsdkcorekit.FBSDKAccessToken;
import de.tomgrill.gdxfacebook.iosmoe.bindings.sdk.login.fbsdkloginkit.FBSDKLoginManager;
import de.tomgrill.gdxfacebook.iosmoe.bindings.sdk.login.fbsdkloginkit.FBSDKLoginManagerLoginResult;
import de.tomgrill.gdxfacebook.iosmoe.bindings.sdk.share.fbsdksharekit.FBSDKGameRequestContent;
import de.tomgrill.gdxfacebook.iosmoe.bindings.sdk.share.fbsdksharekit.FBSDKGameRequestDialog;
import de.tomgrill.gdxfacebook.iosmoe.bindings.sdk.share.fbsdksharekit.protocol.FBSDKGameRequestDialogDelegate;
import java.util.Map;

public class IOSMOEGDXFacebook
extends GDXFacebookBasic {
    private FBSDKLoginManager loginManager = FBSDKLoginManager.alloc().init();
    private SignInMode signInMode;

    public IOSMOEGDXFacebook(GDXFacebookConfig config) {
        super(config);
    }

    public void signIn(SignInMode mode, Array<String> permissions, GDXFacebookCallback<SignInResult> callback) {
        this.callback = callback;
        this.permissions = permissions;
        this.signInMode = mode;
        this.loadAccessToken();
        if (this.accessToken == null && FBSDKAccessToken.currentAccessToken() != null) {
            this.accessToken = new GDXFacebookAccessToken(FBSDKAccessToken.currentAccessToken().tokenString(), (long)FBSDKAccessToken.currentAccessToken().expirationDate().timeIntervalSince1970());
        }
        if (this.accessToken != null) {
            this.startSilentSignIn();
        } else {
            this.startGUISignIn();
        }
    }

    public void showGameRequest(GDXFacebookGameRequest request, GDXFacebookCallback<GameRequestResult> gameRequestCallback) {
        this.gameRequest(request, gameRequestCallback);
    }

    public void gameRequest(GDXFacebookGameRequest request, final GDXFacebookCallback<GameRequestResult> gameRequestCallback) {
        Array recipients;
        Array suggestions;
        Gdx.app.debug("gdx-facebook (1.4.1)", "Starting Game Request dialog.");
        FBSDKGameRequestContent gameRequestContent = FBSDKGameRequestContent.alloc();
        if (request.getMessage() != null) {
            gameRequestContent.setMessage(request.getMessage());
        }
        if (request.getData() != null) {
            gameRequestContent.setData(request.getData());
        }
        if (request.getTitle() != null) {
            gameRequestContent.setTitle(request.getTitle());
        }
        if (request.getObjectId() != null) {
            gameRequestContent.setObjectID(request.getObjectId());
        }
        if ((suggestions = request.getSuggestions()) != null && suggestions.size > 0) {
            NSMutableArray suggestionList = NSMutableArray.array();
            for (int i = 0; i < suggestions.size; ++i) {
                suggestionList.addObject(suggestions.get(i));
            }
            gameRequestContent.setRecipientSuggestions((NSArray<?>)suggestionList);
        }
        if ((recipients = request.getRecipients()) != null && recipients.size > 0) {
            NSMutableArray recipientsList = NSMutableArray.array();
            for (int i = 0; i < recipients.size; ++i) {
                recipientsList.addObject(recipients.get(i));
            }
            gameRequestContent.setRecipients((NSArray<?>)recipientsList);
        }
        if (request.getActionType() != null) {
            switch (request.getActionType()) {
                case ASKFOR: {
                    gameRequestContent.setActionType(2L);
                    break;
                }
                case SEND: {
                    gameRequestContent.setActionType(1L);
                    break;
                }
                case TURN: {
                    gameRequestContent.setActionType(3L);
                }
            }
        }
        if (request.getFilters() != null) {
            switch (request.getFilters()) {
                case APP_NON_USERS: {
                    gameRequestContent.setFilters(2L);
                    break;
                }
                case APP_USERS: {
                    gameRequestContent.setFilters(1L);
                }
            }
        }
        FBSDKGameRequestDialog.showWithContentDelegate(gameRequestContent, new FBSDKGameRequestDialogDelegate(){

            @Override
            public void gameRequestDialogDidCompleteWithResults(FBSDKGameRequestDialog gameRequestDialog, NSDictionary<?, ?> results) {
                Array recipients = new Array();
                String requestId = "";
                for (Map.Entry entry : results.entrySet()) {
                    String key = entry.getKey().toString();
                    String value = entry.getValue().toString();
                    if (key.equals("request")) {
                        requestId = value;
                        continue;
                    }
                    recipients.add((Object)value);
                }
                Gdx.app.debug("gdx-facebook (1.4.1)", "User finished Game Request dialog successful.");
                gameRequestCallback.onSuccess((Result)new GameRequestResult(requestId, recipients));
            }

            @Override
            public void gameRequestDialogDidFailWithError(FBSDKGameRequestDialog gameRequestDialog, NSError error) {
                Gdx.app.debug("gdx-facebook (1.4.1)", "Game Request finished with error: " + error.localizedDescription());
                gameRequestCallback.onError(new GDXFacebookError(error.localizedDescription()));
            }

            @Override
            public void gameRequestDialogDidCancel(FBSDKGameRequestDialog gameRequestDialog) {
                Gdx.app.debug("gdx-facebook (1.4.1)", "Game Request has been fail.");
                gameRequestCallback.onCancel();
            }
        });
    }

    public void signOut(boolean keepSessionData) {
        super.signOut(keepSessionData);
        this.loginManager.logOut();
        if (!keepSessionData) {
            FBSDKAccessToken.setCurrentAccessToken(null);
            this.deleteTokenData();
        }
    }

    public boolean isLoaded() {
        return true;
    }

    protected void startGUISignIn() {
        Gdx.app.debug("gdx-facebook (1.4.1)", "Starting GUI sign in.");
        NSMutableArray listPermissions = NSMutableArray.array();
        for (int i = 0; i < this.permissions.size; ++i) {
            listPermissions.addObject(this.permissions.get(i));
        }
        if (this.signInMode == SignInMode.PUBLISH) {
            this.loginManager.logInWithPublishPermissionsFromViewControllerHandler((NSArray<?>)listPermissions, ((IOSApplication)Gdx.app).getUIViewController(), new FBSDKLoginManager.Block_logInWithPublishPermissionsFromViewControllerHandler(){

                @Override
                public void call_logInWithPublishPermissionsFromViewControllerHandler(FBSDKLoginManagerLoginResult loginResult, NSError nsError) {
                    if (nsError != null) {
                        IOSMOEGDXFacebook.this.signOut();
                        Gdx.app.debug("gdx-facebook (1.4.1)", "Error while trying to sign in: " + nsError.localizedDescription());
                        IOSMOEGDXFacebook.this.callback.onError(new GDXFacebookError(nsError.localizedDescription()));
                    } else if (loginResult.isCancelled()) {
                        Gdx.app.debug("gdx-facebook (1.4.1)", "Sign fail by user.");
                        IOSMOEGDXFacebook.this.signOut();
                        IOSMOEGDXFacebook.this.callback.onCancel();
                    } else {
                        IOSMOEGDXFacebook.this.accessToken = new GDXFacebookAccessToken(FBSDKAccessToken.currentAccessToken().tokenString(), (long)FBSDKAccessToken.currentAccessToken().expirationDate().timeIntervalSince1970());
                        Gdx.app.debug("gdx-facebook (1.4.1)", "Sign successful. User token: " + IOSMOEGDXFacebook.this.accessToken.getToken());
                        IOSMOEGDXFacebook.this.callback.onSuccess((Result)new SignInResult(IOSMOEGDXFacebook.this.accessToken, "Sign in successful."));
                    }
                }
            });
        } else {
            this.loginManager.logInWithReadPermissionsFromViewControllerHandler((NSArray<?>)listPermissions, ((IOSApplication)Gdx.app).getUIViewController(), new FBSDKLoginManager.Block_logInWithReadPermissionsFromViewControllerHandler(){

                @Override
                public void call_logInWithReadPermissionsFromViewControllerHandler(FBSDKLoginManagerLoginResult loginResult, NSError nsError) {
                    if (nsError != null) {
                        IOSMOEGDXFacebook.this.signOut();
                        Gdx.app.debug("gdx-facebook (1.4.1)", "Error while trying to sign in: " + nsError.localizedDescription());
                        IOSMOEGDXFacebook.this.callback.onError(new GDXFacebookError(nsError.localizedDescription()));
                    } else if (loginResult.isCancelled()) {
                        Gdx.app.debug("gdx-facebook (1.4.1)", "Sign fail by user.");
                        IOSMOEGDXFacebook.this.signOut();
                        IOSMOEGDXFacebook.this.callback.onCancel();
                    } else {
                        IOSMOEGDXFacebook.this.accessToken = new GDXFacebookAccessToken(FBSDKAccessToken.currentAccessToken().tokenString(), (long)FBSDKAccessToken.currentAccessToken().expirationDate().timeIntervalSince1970());
                        IOSMOEGDXFacebook.this.storeNewToken(IOSMOEGDXFacebook.this.accessToken);
                        Gdx.app.debug("gdx-facebook (1.4.1)", "Sign successful. User token: " + IOSMOEGDXFacebook.this.accessToken.getToken());
                        IOSMOEGDXFacebook.this.callback.onSuccess((Result)new SignInResult(IOSMOEGDXFacebook.this.accessToken, "Sign in successful."));
                    }
                }
            });
        }
    }
}

