/*
 * Decompiled with CFR 0.152.
 */
package de.tomgrill.gdxfacebook.iosmoe;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;
import de.tomgrill.gdxfacebook.core.GDXFacebookAccessToken;
import de.tomgrill.gdxfacebook.core.GDXFacebookBasic;
import de.tomgrill.gdxfacebook.core.GDXFacebookCallback;
import de.tomgrill.gdxfacebook.core.GDXFacebookConfig;
import de.tomgrill.gdxfacebook.core.GDXFacebookError;
import de.tomgrill.gdxfacebook.core.GDXFacebookGameRequest;
import de.tomgrill.gdxfacebook.core.GameRequestResult;
import de.tomgrill.gdxfacebook.core.Result;
import de.tomgrill.gdxfacebook.core.SignInMode;
import de.tomgrill.gdxfacebook.core.SignInResult;
import java.util.ArrayList;
import java.util.Map;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSObject;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.pods.facebook.core.FBSDKAccessToken;
import org.robovm.pods.facebook.login.FBSDKLoginManager;
import org.robovm.pods.facebook.login.FBSDKLoginManagerLoginResult;
import org.robovm.pods.facebook.share.FBSDKGameRequestActionType;
import org.robovm.pods.facebook.share.FBSDKGameRequestContent;
import org.robovm.pods.facebook.share.FBSDKGameRequestDialog;
import org.robovm.pods.facebook.share.FBSDKGameRequestDialogDelegate;
import org.robovm.pods.facebook.share.FBSDKGameRequestDialogDelegateAdapter;
import org.robovm.pods.facebook.share.FBSDKGameRequestFilter;

public class IOSMOEGDXFacebook
extends GDXFacebookBasic {
    private FBSDKLoginManager loginManager = new FBSDKLoginManager();
    private SignInMode signInMode;

    public IOSMOEGDXFacebook(GDXFacebookConfig config) {
        super(config);
    }

    public void signIn(SignInMode mode, Array<String> permissions, GDXFacebookCallback<SignInResult> callback) {
        this.callback = callback;
        this.permissions = permissions;
        this.signInMode = mode;
        this.loadAccessToken();
        if (this.accessToken == null && FBSDKAccessToken.getCurrentAccessToken() != null) {
            this.accessToken = new GDXFacebookAccessToken(FBSDKAccessToken.getCurrentAccessToken().getTokenString(), FBSDKAccessToken.getCurrentAccessToken().getExpirationDate().toDate().getTime());
        }
        if (this.accessToken != null) {
            this.startSilentSignIn();
        } else {
            this.startGUISignIn();
        }
    }

    public void showGameRequest(GDXFacebookGameRequest request, GDXFacebookCallback<GameRequestResult> gameRequestCallback) {
        this.gameRequest(request, gameRequestCallback);
    }

    public void gameRequest(GDXFacebookGameRequest request, final GDXFacebookCallback<GameRequestResult> gameRequestCallback) {
        Array recipients;
        Array suggestions;
        Gdx.app.debug("gdx-facebook (1.2.4)", "Starting Game Request dialog.");
        FBSDKGameRequestContent gameRequestContent = new FBSDKGameRequestContent();
        if (request.getMessage() != null) {
            gameRequestContent.setMessage(request.getMessage());
        }
        if (request.getData() != null) {
            gameRequestContent.setData(request.getData());
        }
        if (request.getTitle() != null) {
            gameRequestContent.setTitle(request.getTitle());
        }
        if (request.getObjectId() != null) {
            gameRequestContent.setObjectID(request.getObjectId());
        }
        if ((suggestions = request.getSuggestions()) != null && suggestions.size > 0) {
            ArrayList<Object> suggestionList = new ArrayList<Object>();
            for (int i = 0; i < suggestions.size; ++i) {
                suggestionList.add(suggestions.get(i));
            }
            gameRequestContent.setRecipientSuggestions(suggestionList);
        }
        if ((recipients = request.getRecipients()) != null && recipients.size > 0) {
            ArrayList<Object> recipientsList = new ArrayList<Object>();
            for (int i = 0; i < recipients.size; ++i) {
                recipientsList.add(recipients.get(i));
            }
            gameRequestContent.setRecipients(recipientsList);
        }
        if (request.getActionType() != null) {
            switch (request.getActionType()) {
                case ASKFOR: {
                    gameRequestContent.setActionType(FBSDKGameRequestActionType.AskFor);
                    break;
                }
                case SEND: {
                    gameRequestContent.setActionType(FBSDKGameRequestActionType.Send);
                    break;
                }
                case TURN: {
                    gameRequestContent.setActionType(FBSDKGameRequestActionType.Turn);
                }
            }
        }
        if (request.getFilters() != null) {
            switch (request.getFilters()) {
                case APP_NON_USERS: {
                    gameRequestContent.setFilters(FBSDKGameRequestFilter.AppNonUsers);
                    break;
                }
                case APP_USERS: {
                    gameRequestContent.setFilters(FBSDKGameRequestFilter.AppUsers);
                }
            }
        }
        FBSDKGameRequestDialog.show((FBSDKGameRequestContent)gameRequestContent, (FBSDKGameRequestDialogDelegate)new FBSDKGameRequestDialogDelegateAdapter(){

            public void didComplete(FBSDKGameRequestDialog gameRequestDialog, NSDictionary<?, ?> results) {
                Array recipients = new Array();
                String requestId = "";
                for (Map.Entry entry : results.entrySet()) {
                    String key = ((NSObject)entry.getKey()).toString();
                    String value = ((NSObject)entry.getValue()).toString();
                    if (key.equals("request")) {
                        requestId = value;
                        continue;
                    }
                    recipients.add((Object)value);
                }
                Gdx.app.debug("gdx-facebook (1.2.4)", "User finished Game Request dialog successful.");
                gameRequestCallback.onSuccess((Result)new GameRequestResult(requestId, recipients));
            }

            public void didFail(FBSDKGameRequestDialog gameRequestDialog, NSError error) {
                Gdx.app.debug("gdx-facebook (1.2.4)", "Game Request finished with error: " + error.getLocalizedDescription());
                gameRequestCallback.onError(new GDXFacebookError(error.getLocalizedDescription()));
            }

            public void didCancel(FBSDKGameRequestDialog gameRequestDialog) {
                Gdx.app.debug("gdx-facebook (1.2.4)", "Game Request has been fail.");
                gameRequestCallback.onCancel();
            }
        });
    }

    public void signOut(boolean keepSessionData) {
        super.signOut(keepSessionData);
        this.loginManager.logOut();
        if (!keepSessionData) {
            FBSDKAccessToken.setCurrentAccessToken(null);
            this.deleteTokenData();
        }
    }

    public boolean isLoaded() {
        return true;
    }

    protected void startGUISignIn() {
        Gdx.app.debug("gdx-facebook (1.2.4)", "Starting GUI sign in.");
        VoidBlock2<FBSDKLoginManagerLoginResult, NSError> result = new VoidBlock2<FBSDKLoginManagerLoginResult, NSError>(){

            public void invoke(FBSDKLoginManagerLoginResult loginResult, NSError nsError) {
                if (nsError != null) {
                    IOSMOEGDXFacebook.this.signOut();
                    Gdx.app.debug("gdx-facebook (1.2.4)", "Error while trying to sign in: " + nsError.getLocalizedDescription());
                    IOSMOEGDXFacebook.this.callback.onError(new GDXFacebookError(nsError.getLocalizedDescription()));
                } else if (loginResult.isCancelled()) {
                    Gdx.app.debug("gdx-facebook (1.2.4)", "Sign fail by user.");
                    IOSMOEGDXFacebook.this.signOut();
                    IOSMOEGDXFacebook.this.callback.onCancel();
                } else {
                    IOSMOEGDXFacebook.this.accessToken = new GDXFacebookAccessToken(FBSDKAccessToken.getCurrentAccessToken().getTokenString(), FBSDKAccessToken.getCurrentAccessToken().getExpirationDate().toDate().getTime());
                    IOSMOEGDXFacebook.this.storeNewToken(IOSMOEGDXFacebook.this.accessToken);
                    Gdx.app.debug("gdx-facebook (1.2.4)", "Sign successful. User token: " + IOSMOEGDXFacebook.this.accessToken.getToken());
                    IOSMOEGDXFacebook.this.callback.onSuccess((Result)new SignInResult(IOSMOEGDXFacebook.this.accessToken, "Sign in successful."));
                }
            }
        };
        ArrayList<Object> listPermissions = new ArrayList<Object>();
        for (int i = 0; i < this.permissions.size; ++i) {
            listPermissions.add(this.permissions.get(i));
        }
        if (this.signInMode == SignInMode.PUBLISH) {
            this.loginManager.logInWithPublishPermissions(listPermissions, (VoidBlock2)result);
        } else {
            this.loginManager.logInWithReadPermissions(listPermissions, (VoidBlock2)result);
        }
    }
}

