/*
 * Decompiled with CFR 0.152.
 */
package de.tomgrill.gdxfacebook.desktop;

import com.badlogic.gdx.utils.Array;
import de.tomgrill.gdxfacebook.core.GDXFacebookConfig;
import de.tomgrill.gdxfacebook.core.utils.Utils;
import de.tomgrill.gdxfacebook.desktop.JXBrowserCallbackHandler;
import java.net.CookieHandler;
import java.net.CookieManager;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class JXBrowser
extends Application {
    private static final String LAUNCH_PARAMETERS = "";
    private static boolean hasBeenLaunched = false;
    private static JXBrowserCallbackHandler callbackHandler;
    private static String appId;
    private static String permissions;
    private static String url;
    private static WebView webView;
    private static WebEngine webEngine;
    private static Stage primaryStage;
    private static StackPane stackPane;
    private static Scene rootScene;

    private static void showGUILogin() {
        if (!hasBeenLaunched) {
            hasBeenLaunched = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    JXBrowser.launchApplication();
                }
            }).start();
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    JXBrowser.reuseApplication();
                }
            });
        }
    }

    private static void launchApplication() {
        JXBrowser.launch((String[])new String[]{LAUNCH_PARAMETERS});
    }

    private static void reuseApplication() {
        CookieHandler.setDefault(new CookieManager());
        webEngine.loadContent(LAUNCH_PARAMETERS);
        webEngine.load(url);
        primaryStage.show();
    }

    public void start(Stage pStage) throws Exception {
        Platform.setImplicitExit((boolean)false);
        primaryStage = pStage;
        primaryStage.setAlwaysOnTop(true);
        primaryStage.setTitle("Facebook Sign in");
        webView = new WebView();
        CookieHandler.setDefault(new CookieManager());
        webEngine = webView.getEngine();
        webEngine.load(url);
        webEngine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String oldLocation, String newLocation) {
                if (Utils.isValidSuccessfulSignInURL((String)newLocation) || Utils.isValidErrorSignInURL((String)newLocation)) {
                    callbackHandler.handleURL(newLocation);
                    JXBrowser.this.closeBrowser();
                }
            }
        });
        stackPane = new StackPane();
        stackPane.getChildren().add((Object)webView);
        rootScene = new Scene((Parent)stackPane);
        primaryStage.setScene(rootScene);
        primaryStage.show();
        primaryStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                callbackHandler.handleCancel();
            }
        });
    }

    private void closeBrowser() {
        primaryStage.close();
    }

    public static void setAppId(String app_id) {
        appId = app_id;
    }

    public static void setPermissions(Array<String> permissions) {
        JXBrowser.permissions = Utils.permissionsArrayToString(permissions);
    }

    public static void login(Array<String> permissions, GDXFacebookConfig config, JXBrowserCallbackHandler handler) {
        JXBrowser.setAppId(config.APP_ID);
        JXBrowser.setPermissions(permissions);
        callbackHandler = handler;
        JXBrowser.buildURL();
        JXBrowser.showGUILogin();
    }

    private static void buildURL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("https://www.facebook.com/dialog/oauth?");
        stringBuffer.append("client_id=");
        stringBuffer.append(appId);
        stringBuffer.append("&redirect_uri=https://www.facebook.com/connect/login_success.html");
        stringBuffer.append("&scope=");
        stringBuffer.append(permissions);
        stringBuffer.append("&response_type=token");
        url = stringBuffer.toString();
    }
}

