/*
 * Decompiled with CFR 0.152.
 */
package de.tomgrill.gdxfacebook.desktop;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import com.badlogic.gdx.utils.TimeUtils;
import de.tomgrill.gdxfacebook.core.GDXFacebook;
import de.tomgrill.gdxfacebook.core.GDXFacebookAccessToken;
import de.tomgrill.gdxfacebook.core.GDXFacebookCallback;
import de.tomgrill.gdxfacebook.core.GDXFacebookConfig;
import de.tomgrill.gdxfacebook.core.GDXFacebookError;
import de.tomgrill.gdxfacebook.core.GDXFacebookGameRequest;
import de.tomgrill.gdxfacebook.core.GameRequestResult;
import de.tomgrill.gdxfacebook.core.Result;
import de.tomgrill.gdxfacebook.core.SignInMode;
import de.tomgrill.gdxfacebook.core.SignInResult;
import de.tomgrill.gdxfacebook.core.utils.Utils;
import de.tomgrill.gdxfacebook.desktop.JXBrowser;
import de.tomgrill.gdxfacebook.desktop.JXBrowserCallbackHandler;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;

public class DesktopGDXFacebook
extends GDXFacebook
implements JXBrowserCallbackHandler {
    public DesktopGDXFacebook(GDXFacebookConfig config) {
        super(config);
    }

    public void signIn(SignInMode mode, Array<String> permissions, GDXFacebookCallback<SignInResult> callback) {
        this.callback = callback;
        this.permissions = permissions;
        this.loadAccessToken();
        if (this.accessToken != null) {
            this.startSilentSignIn();
        } else {
            this.startGUISignIn();
        }
    }

    public void showGameRequest(GDXFacebookGameRequest request, GDXFacebookCallback<GameRequestResult> callback) {
        Gdx.app.debug("gdx-facebook (1.0.0)", "Game Request not supported on Desktop");
    }

    protected void startGUISignIn() {
        if (this.accessToken == null) {
            JXBrowser.login((Array<String>)this.permissions, this.config, this);
            Gdx.app.debug("gdx-facebook (1.0.0)", "Starting GUI sign in.");
        }
    }

    public boolean isSignedIn() {
        return this.accessToken != null;
    }

    @Override
    public void handleURL(String url) {
        if (Utils.isValidErrorSignInURL((String)url)) {
            this.handleErrorSignIn(url);
        } else if (Utils.isValidSuccessfulSignInURL((String)url)) {
            this.handleSuccessSignIn(url);
        }
    }

    private void handleSuccessSignIn(String url) {
        try {
            URL urlObj = new URL(url);
            ArrayMap params = Utils.parseQuery((String)urlObj.getRef());
            this.accessToken = new GDXFacebookAccessToken((String)params.get((Object)"access_token"), (long)Integer.parseInt((String)params.get((Object)"expires_in")) + TimeUtils.millis() / 1000L);
            this.storeNewToken(this.accessToken);
            Gdx.app.debug("gdx-facebook (1.0.0)", "Sign successful. User token: " + this.accessToken.getToken());
            this.callback.onSuccess((Result)new SignInResult(this.accessToken, "Sign in successful."));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void handleErrorSignIn(String url) {
        try {
            URL urlObj = new URL(url);
            String errorMessage = urlObj.getQuery();
            if (errorMessage != null) {
                Gdx.app.debug("gdx-facebook (1.0.0)", "Error while trying to sign in: " + errorMessage);
                this.callback.onError(new GDXFacebookError(errorMessage));
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleCancel() {
        Gdx.app.debug("gdx-facebook (1.0.0)", "Sign in has been cancelled");
        this.callback.onCancel();
    }
}

