/*
 * Decompiled with CFR 0.152.
 */
package de.tomgrill.gdxfacebook.core;

import com.badlogic.gdx.utils.ArrayMap;
import com.badlogic.gdx.utils.ObjectMap;
import de.tomgrill.gdxfacebook.core.AbstractRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class GDXFacebookGraphRequest
extends AbstractRequest {
    public static String defaultEncoding = "UTF-8";
    public static String nameValueSeparator = "=";
    public static String parameterSeparator = "&";

    private static String encode(String content, String encoding) {
        try {
            return URLEncoder.encode(content, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public final ArrayMap<String, String> getHeaders() {
        return null;
    }

    @Override
    public String getContent() {
        StringBuffer convertedParameters = new StringBuffer();
        for (ObjectMap.Entry entry : this.fields) {
            convertedParameters.append(GDXFacebookGraphRequest.encode((String)entry.key, defaultEncoding));
            convertedParameters.append(nameValueSeparator);
            convertedParameters.append(GDXFacebookGraphRequest.encode((String)entry.value, defaultEncoding));
            convertedParameters.append(parameterSeparator);
        }
        if (convertedParameters.length() > 0) {
            convertedParameters.deleteCharAt(convertedParameters.length() - 1);
        }
        return convertedParameters.toString();
    }

    @Override
    public String getJavascriptObjectString() {
        StringBuffer convertedParameters = new StringBuffer();
        for (ObjectMap.Entry entry : this.fields) {
            convertedParameters.append((String)entry.key);
            convertedParameters.append(":\"");
            convertedParameters.append(((String)entry.value).replace("\"", "\\\""));
            convertedParameters.append("\",");
        }
        if (convertedParameters.length() > 0) {
            convertedParameters.deleteCharAt(convertedParameters.length() - 1);
        }
        return convertedParameters.toString();
    }

    @Override
    public final InputStream getContentStream() throws IOException {
        return null;
    }

    @Override
    public GDXFacebookGraphRequest useCurrentAccessToken() {
        return (GDXFacebookGraphRequest)super.useCurrentAccessToken();
    }

    @Override
    public GDXFacebookGraphRequest setNode(String node) {
        return (GDXFacebookGraphRequest)super.setNode(node);
    }

    @Override
    public GDXFacebookGraphRequest setMethod(String method) {
        return (GDXFacebookGraphRequest)super.setMethod(method);
    }

    @Override
    public GDXFacebookGraphRequest setTimeout(int timeout) {
        return (GDXFacebookGraphRequest)super.setTimeout(timeout);
    }

    @Override
    public GDXFacebookGraphRequest putField(String key, String value) {
        return (GDXFacebookGraphRequest)super.putField(key, value);
    }

    @Override
    public GDXFacebookGraphRequest putFields(ArrayMap<String, String> fields) {
        return (GDXFacebookGraphRequest)super.putFields(fields);
    }
}

