/*
 * Decompiled with CFR 0.152.
 */
package de.tomgrill.gdxfacebook.core;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import de.tomgrill.gdxfacebook.core.FacebookLoader;
import de.tomgrill.gdxfacebook.core.FallbackGDXFacebook;
import de.tomgrill.gdxfacebook.core.GDXFacebook;
import de.tomgrill.gdxfacebook.core.GDXFacebookConfig;

public class ReflectionLoader {
    public static GDXFacebook load(GDXFacebookConfig config) {
        block8: {
            try {
                Class loaderCls = null;
                if (Gdx.app.getType() == Application.ApplicationType.Android) {
                    loaderCls = ClassReflection.forName((String)"de.tomgrill.gdxfacebook.android.AndroidFacebookLoader");
                }
                if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
                    loaderCls = ClassReflection.forName((String)"de.tomgrill.gdxfacebook.desktop.DesktopFacebookLoader");
                }
                if (Gdx.app.getType() == Application.ApplicationType.iOS) {
                    try {
                        loaderCls = ClassReflection.forName((String)"de.tomgrill.gdxfacebook.ios.IOSFacebookLoader");
                    }
                    catch (ReflectionException e) {
                        loaderCls = ClassReflection.forName((String)"de.tomgrill.gdxfacebook.iosmoe.IOSMOEFacebookLoader");
                    }
                }
                if (loaderCls != null) {
                    Object loaderObj = ClassReflection.getConstructor((Class)loaderCls, (Class[])new Class[0]).newInstance(new Object[0]);
                    Gdx.app.debug("gdx-facebook (1.4.0)", "gdx-facebook (1.4.0) for " + Gdx.app.getType() + " installed successfully.");
                    return ((FacebookLoader)loaderObj).load(config);
                }
            }
            catch (ReflectionException e) {
                Gdx.app.error("gdx-facebook (1.4.0)", "Error installing gdx-facebook (1.4.0) for " + Gdx.app.getType() + "\n");
                Gdx.app.error("gdx-facebook (1.4.0)", "Did you add >> compile \"de.tomgrill.gdxfacebook:gdx-facebook-" + ReflectionLoader.artifactByAppType(Gdx.app.getType()) + ":" + "1.4.0" + "\" << to your gradle dependencies? View https://github.com/TomGrill/gdx-facebook/wiki for more information.\n");
                if (Gdx.app.getType() != Application.ApplicationType.iOS) break block8;
                Gdx.app.error("gdx-facebook (1.4.0)", "or in cas you use multi-os-engine >> compile \"de.tomgrill.gdxfacebook:gdx-facebook-ios-moe:1.4.0\" <<\n");
            }
        }
        return new FallbackGDXFacebook();
    }

    private static String artifactByAppType(Application.ApplicationType type) {
        if (type == Application.ApplicationType.Android) {
            return "android";
        }
        if (type == Application.ApplicationType.iOS) {
            return "ios";
        }
        if (type == Application.ApplicationType.Desktop) {
            return "desktop";
        }
        return "unknown_type";
    }
}

