/*
 * Decompiled with CFR 0.152.
 */
package de.tomgrill.gdxfacebook.html;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.TimeUtils;
import de.tomgrill.gdxfacebook.core.GDXFacebook;
import de.tomgrill.gdxfacebook.core.GDXFacebookAccessToken;
import de.tomgrill.gdxfacebook.core.GDXFacebookCallback;
import de.tomgrill.gdxfacebook.core.GDXFacebookConfig;
import de.tomgrill.gdxfacebook.core.GDXFacebookError;
import de.tomgrill.gdxfacebook.core.GDXFacebookGameRequest;
import de.tomgrill.gdxfacebook.core.GDXFacebookGraphRequest;
import de.tomgrill.gdxfacebook.core.GDXFacebookMultiPartRequest;
import de.tomgrill.gdxfacebook.core.GameRequestResult;
import de.tomgrill.gdxfacebook.core.JsonResult;
import de.tomgrill.gdxfacebook.core.Request;
import de.tomgrill.gdxfacebook.core.SignInMode;
import de.tomgrill.gdxfacebook.core.SignInResult;
import de.tomgrill.gdxfacebook.html.JSNIFacebookSDK;
import de.tomgrill.gdxfacebook.html.JsonCallback;
import de.tomgrill.gdxfacebook.html.LoginCallback;
import de.tomgrill.gdxfacebook.html.StatusCallback;

public class HTMLGDXFacebook
implements GDXFacebook {
    private GDXFacebookConfig config;
    private Preferences preferences;
    boolean loaded = false;
    private boolean isConnected;
    private GDXFacebookAccessToken accessToken;
    private Array<String> grantedPermissions = new Array();

    public HTMLGDXFacebook(GDXFacebookConfig config) {
        this.config = config;
        this.preferences = Gdx.app.getPreferences(config.PREF_FILENAME);
    }

    private void loadAccessToken() {
        String token = this.preferences.getString("access_token", null);
        long expiresAt = this.preferences.getLong("expires_at", 0L);
        if (token != null && expiresAt > 0L) {
            Gdx.app.debug("gdx-facebook (1.3.0)", "Loaded existing accessToken: " + token);
            this.accessToken = new GDXFacebookAccessToken(token, expiresAt);
        } else {
            Gdx.app.debug("gdx-facebook (1.3.0)", "No accessToken found.");
        }
    }

    @Override
    public void signIn(SignInMode mode, Array<String> permissions, GDXFacebookCallback<SignInResult> callback) {
        if (!this.loaded) {
            Gdx.app.debug("gdx-facebook (1.3.0)", "Facebook SDK not yet loaded. Try again later.");
            return;
        }
        this.loadAccessToken();
        if (this.accessToken == null) {
            this.guiLogin(permissions, callback);
        } else {
            this.silentLogin(permissions, callback);
        }
    }

    private boolean areSamePermissionsOrMore(Array<String> requiredPermissions, Array<String> allPermissions) {
        for (String s : requiredPermissions) {
            if (allPermissions.contains((Object)s, false)) continue;
            return false;
        }
        return true;
    }

    private void silentLogin(final Array<String> permissions, final GDXFacebookCallback<SignInResult> callback) {
        Gdx.app.debug("gdx-facebook (1.3.0)", "Starting silent sign in.");
        this.signOut(false);
        JSNIFacebookSDK.FBLoginState(new StatusCallback(){

            @Override
            public void connected(String token, String expiresIn) {
                HTMLGDXFacebook.this.isConnected = true;
                long expiresInMillisFromNow = Long.valueOf(expiresIn) * 1000L;
                long expiresInMillisTimestamp = expiresInMillisFromNow + TimeUtils.millis();
                HTMLGDXFacebook.this.accessToken = new GDXFacebookAccessToken(token, expiresInMillisTimestamp);
                HTMLGDXFacebook.this.storeToken(HTMLGDXFacebook.this.accessToken);
                HTMLGDXFacebook.this.validatePermissions((Array<String>)permissions, callback);
            }

            @Override
            public void notAuthorized() {
                HTMLGDXFacebook.this.guiLogin((Array<String>)permissions, callback);
            }

            @Override
            public void disconnected() {
                HTMLGDXFacebook.this.guiLogin((Array<String>)permissions, callback);
            }
        });
    }

    private void validatePermissions(final Array<String> permissions, final GDXFacebookCallback<SignInResult> callback) {
        Gdx.app.debug("gdx-facebook (1.3.0)", "Checking for permissions");
        GDXFacebookGraphRequest request = new GDXFacebookGraphRequest();
        request.setMethod("GET");
        request.setNode("me/permissions");
        request.useCurrentAccessToken();
        this.graph(request, new GDXFacebookCallback<JsonResult>(){

            @Override
            public void onSuccess(JsonResult result) {
                JsonValue dataValue;
                JsonValue value = result.getJsonValue();
                if (value != null && value.has("data") && (dataValue = value.get("data")) != null && dataValue.isArray()) {
                    HTMLGDXFacebook.this.grantedPermissions.clear();
                    for (int i = 0; i < dataValue.size; ++i) {
                        JsonValue permission = dataValue.get(i);
                        if (!permission.getString("status").equals("granted")) continue;
                        HTMLGDXFacebook.this.grantedPermissions.add((Object)permission.getString("permission").toLowerCase());
                    }
                    if (HTMLGDXFacebook.this.areSamePermissionsOrMore((Array<String>)permissions, (Array<String>)HTMLGDXFacebook.this.grantedPermissions)) {
                        Gdx.app.debug("gdx-facebook (1.3.0)", "AccessToken and permissions are valid.");
                        callback.onSuccess(new SignInResult(HTMLGDXFacebook.this.accessToken, "AccessToken and permissions are valid."));
                        return;
                    }
                }
                HTMLGDXFacebook.this.guiLogin((Array<String>)permissions, callback);
            }

            @Override
            public void onError(GDXFacebookError error) {
                HTMLGDXFacebook.this.guiLogin((Array<String>)permissions, callback);
            }

            @Override
            public void onFail(Throwable t) {
                HTMLGDXFacebook.this.guiLogin((Array<String>)permissions, callback);
            }

            @Override
            public void onCancel() {
                HTMLGDXFacebook.this.guiLogin((Array<String>)permissions, callback);
            }
        });
    }

    private void guiLogin(final Array<String> permissions, final GDXFacebookCallback<SignInResult> callback) {
        this.signOut(false);
        Gdx.app.debug("gdx-facebook (1.3.0)", "Start GUI login.");
        JSNIFacebookSDK.FBLogin(HTMLGDXFacebook.permissionsArrayToString(permissions), new LoginCallback(){

            @Override
            public void success(String token, String expiresIn, String gPermissions) {
                Gdx.app.debug("gdx-facebook (1.3.0)", "success granted: " + gPermissions);
                String[] parts = gPermissions.split(",");
                HTMLGDXFacebook.this.grantedPermissions.clear();
                for (String s : parts) {
                    HTMLGDXFacebook.this.grantedPermissions.add((Object)s);
                }
                if (HTMLGDXFacebook.this.areSamePermissionsOrMore((Array<String>)permissions, (Array<String>)HTMLGDXFacebook.this.grantedPermissions)) {
                    HTMLGDXFacebook.this.isConnected = true;
                    long expiresInMillisFromNow = Long.valueOf(expiresIn) * 1000L;
                    long expiresInMillisTimestamp = expiresInMillisFromNow + TimeUtils.millis();
                    HTMLGDXFacebook.this.accessToken = new GDXFacebookAccessToken(token, expiresInMillisTimestamp);
                    HTMLGDXFacebook.this.storeToken(HTMLGDXFacebook.this.accessToken);
                    callback.onSuccess(new SignInResult(HTMLGDXFacebook.this.accessToken, "Login successful. AccessToken and permissions are valid."));
                } else {
                    callback.onError(new GDXFacebookError("User did not grant required permissions."));
                }
            }

            @Override
            public void fail() {
                callback.onError(new GDXFacebookError("Error while trying to login. User cancelled or did not authorize."));
            }
        });
    }

    @Override
    public void showGameRequest(GDXFacebookGameRequest request, GDXFacebookCallback<GameRequestResult> callback) {
        this.gameRequest(request, callback);
    }

    @Override
    public void gameRequest(GDXFacebookGameRequest request, GDXFacebookCallback<GameRequestResult> callback) {
        if (!this.loaded) {
            Gdx.app.debug("gdx-facebook (1.3.0)", "Facebook SDK not yet loaded. Try again later.");
            return;
        }
    }

    @Override
    public void newGraphRequest(Request request, GDXFacebookCallback<JsonResult> callback) {
        this.graph(request, callback);
    }

    @Override
    public void graph(Request request, final GDXFacebookCallback<JsonResult> callback) {
        if (!this.loaded) {
            Gdx.app.debug("gdx-facebook (1.3.0)", "Facebook SDK not yet loaded. Try again later.");
            return;
        }
        if (request instanceof GDXFacebookGraphRequest) {
            JSNIFacebookSDK.FBapi(request.getNode(), request.getMethod(), request.getJavascriptObjectString(), new JsonCallback(){

                @Override
                public void jsonResult(String jsonString) {
                    callback.onSuccess(new JsonResult(jsonString));
                }

                @Override
                public void error() {
                    callback.onError(new GDXFacebookError("graph API error. View Javascript log for further details."));
                }
            });
        }
        if (request instanceof GDXFacebookMultiPartRequest) {
            Gdx.app.debug("gdx-facebook (1.3.0)", "Multipart requests are not supported with GWT backend. See: https://github.com/TomGrill/gdx-facebook/issues/32");
        }
    }

    @Override
    public void signOut(boolean keepSessionData) {
        this.accessToken = null;
        this.isConnected = false;
        this.grantedPermissions.clear();
        if (!keepSessionData) {
            this.deleteTokenData();
        }
    }

    @Override
    public void signOut() {
        this.signOut(true);
    }

    @Override
    public boolean isSignedIn() {
        return this.isConnected;
    }

    @Override
    public GDXFacebookAccessToken getAccessToken() {
        return this.accessToken;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    private static String permissionsArrayToString(Array<String> permissions) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < permissions.size; ++i) {
            stringBuilder.append((String)permissions.get(i));
            if (i + 1 >= permissions.size) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    private void deleteTokenData() {
        this.preferences.remove("access_token");
        this.preferences.remove("expires_at");
        this.preferences.flush();
    }

    private void storeToken(GDXFacebookAccessToken token) {
        Gdx.app.debug("gdx-facebook (1.3.0)", "Storing new accessToken: " + token.getToken() + "; expires at: " + token.getExpiresAt());
        this.preferences.putString("access_token", token.getToken());
        this.preferences.putLong("expires_at", token.getExpiresAt());
        this.preferences.flush();
    }
}

