/*
 * Decompiled with CFR 0.152.
 */
package de.tomgrill.gdxfacebook.core;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import com.badlogic.gdx.utils.TimeUtils;
import de.tomgrill.gdxfacebook.core.AbstractRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class GDXFacebookMultiPartRequest
extends AbstractRequest {
    private static int boundaryCounter = 0;
    private ArrayMap<String, String> headers = new ArrayMap();
    private Array<FileHandle> fileHandles = new Array();
    private Array<String> contentTypes = new Array();
    private String boundary = this.generateBoundary();

    public GDXFacebookMultiPartRequest() {
        this.headers.put((Object)"Content-Type", (Object)("multipart/form-data; boundary=" + this.boundary));
    }

    private static byte[] loadFile(FileHandle fileHandle) throws IOException {
        int offset;
        int numRead;
        InputStream is = fileHandle.read();
        long length = fileHandle.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("File size to large");
        }
        byte[] bytes = new byte[(int)length];
        for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + fileHandle.name());
        }
        is.close();
        return bytes;
    }

    private synchronized String generateBoundary() {
        return Long.toHexString(TimeUtils.nanoTime()) + ++boundaryCounter;
    }

    @Override
    public ArrayMap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public final String getContent() {
        return null;
    }

    @Override
    public InputStream getContentStream() throws IOException {
        ByteArrayOutputStream op = new ByteArrayOutputStream();
        if (this.fileHandles.size > 1) {
            String groupBoundary = this.generateBoundary();
            String openGroup = "";
            openGroup = openGroup + "--" + this.boundary + "\r\n";
            openGroup = openGroup + "Content-Disposition: form-data; name=\"files\"\r\n";
            openGroup = openGroup + "Content-Type: multipart/mixed; boundary=" + groupBoundary + "\r\n";
            op.write(openGroup.getBytes());
            for (int i = 0; i < this.fileHandles.size; ++i) {
                FileHandle fileHandle = (FileHandle)this.fileHandles.get(i);
                String fileString = "";
                fileString = fileString + "\r\n--" + groupBoundary + "\r\n";
                fileString = fileString + "Content-Disposition: file; filename=\"" + fileHandle.name() + "\"\r\n";
                fileString = fileString + "Content-Type: image/png\r\n";
                fileString = fileString + "Content-Transfer-Encoding: binary\r\n";
                fileString = fileString + "\r\n";
                op.write(fileString.getBytes());
                op.write(GDXFacebookMultiPartRequest.loadFile(fileHandle));
                if (i + 1 != this.fileHandles.size) continue;
                fileString = "\r\n--" + groupBoundary + "--";
                op.write(fileString.getBytes());
            }
        } else {
            for (int i = 0; i < this.fileHandles.size; ++i) {
                FileHandle fileHandle = (FileHandle)this.fileHandles.get(i);
                String contentType = (String)this.contentTypes.get(i);
                String fileString = "";
                fileString = fileString + "--" + this.boundary + "\r\n";
                fileString = fileString + "Content-Disposition: form-data; name=\"files" + i + "\"; filename=\"" + fileHandle.name() + "\"\r\n";
                fileString = fileString + "Content-Type: " + contentType + "\r\n";
                fileString = fileString + "Content-Transfer-Encoding: binary\r\n";
                fileString = fileString + "\r\n";
                op.write(fileString.getBytes());
                op.write(fileHandle.readBytes());
            }
        }
        for (int i = 0; i < this.fields.size; ++i) {
            String key = (String)this.fields.getKeyAt(i);
            String value = (String)this.fields.getValueAt(i);
            String fieldString = "";
            fieldString = fieldString + "\r\n--" + this.boundary + "\r\n";
            fieldString = fieldString + "Content-Disposition: form-data; name=\"" + key + "\"\r\n";
            fieldString = fieldString + "Content-Type: text/plain; charset=UTF-8\r\n";
            fieldString = fieldString + "\r\n";
            fieldString = fieldString + value;
            if (i + 1 == this.fields.size) {
                fieldString = fieldString + "\r\n--" + this.boundary + "--\r\n";
            }
            op.write(fieldString.getBytes());
        }
        return new ByteArrayInputStream(op.toByteArray());
    }

    public final GDXFacebookMultiPartRequest setFileHandle(FileHandle fileHandle, String contentType) {
        this.fileHandles.clear();
        this.contentTypes.clear();
        this.fileHandles.add((Object)fileHandle);
        this.contentTypes.add((Object)contentType);
        return this;
    }

    @Override
    public final String getMethod() {
        return "POST";
    }

    @Override
    public final GDXFacebookMultiPartRequest setMethod(String method) {
        return this;
    }

    @Override
    public GDXFacebookMultiPartRequest useCurrentAccessToken() {
        return (GDXFacebookMultiPartRequest)super.useCurrentAccessToken();
    }

    @Override
    public GDXFacebookMultiPartRequest setNode(String node) {
        return (GDXFacebookMultiPartRequest)super.setNode(node);
    }

    @Override
    public GDXFacebookMultiPartRequest setTimeout(int timeout) {
        return (GDXFacebookMultiPartRequest)super.setTimeout(timeout);
    }

    @Override
    public GDXFacebookMultiPartRequest putField(String key, String value) {
        return (GDXFacebookMultiPartRequest)super.putField(key, value);
    }

    @Override
    public GDXFacebookMultiPartRequest putFields(ArrayMap<String, String> fields) {
        return (GDXFacebookMultiPartRequest)super.putFields(fields);
    }

    @Override
    public String getJavascriptObjectString() {
        return "";
    }
}

