/*
 * Decompiled with CFR 0.152.
 */
package de.tomgrill.gdxfacebook.core;

import com.badlogic.gdx.utils.ArrayMap;
import de.tomgrill.gdxfacebook.core.Request;

public abstract class AbstractRequest
implements Request {
    protected String node = "";
    protected String url = "https://graph.facebook.com/";
    protected boolean useCurrentAccessToken = false;
    private String method = "GET";
    private int timeout = 10000;
    protected ArrayMap<String, String> fields = new ArrayMap();

    @Override
    public AbstractRequest useCurrentAccessToken() {
        this.useCurrentAccessToken = true;
        return this;
    }

    @Override
    public boolean isUseCurrentAccessToken() {
        return this.useCurrentAccessToken;
    }

    @Override
    public AbstractRequest setNode(String node) {
        this.node = node.trim();
        if (this.node.startsWith("/")) {
            this.node = this.node.replaceFirst("/", "");
        }
        return this;
    }

    @Override
    public String getNode() {
        return this.node;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public AbstractRequest setMethod(String method) {
        this.method = method;
        return this;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public AbstractRequest setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public AbstractRequest putField(String key, String value) {
        this.fields.put((Object)key, (Object)value);
        return this;
    }

    @Override
    public AbstractRequest putFields(ArrayMap<String, String> fields) {
        fields.putAll(fields);
        return this;
    }
}

