/*******************************************************************************
 * Copyright 2015 See AUTHORS file.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/


package de.tomgrill.gdxfacebook.core;

public class GDXFacebookAccessToken {

    private String token;
    private long expiresAt;


    public GDXFacebookAccessToken(String token, long expiresIn) {
        setToken(token);
        setExpiresAt(expiresIn);
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        if (token == null) {
            throw new NullPointerException("token may not be null.");
        }
        this.token = token;
    }


    public long getExpiresAt() {
        return expiresAt;
    }

    public void setExpiresAt(long expiresAt) {
        this.expiresAt = expiresAt;
    }
}
