/*
 * Decompiled with CFR 0.152.
 */
package de.tomgrill.gdxfacebook.core;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import de.tomgrill.gdxfacebook.core.FallbackGDXFacebook;
import de.tomgrill.gdxfacebook.core.GDXFacebook;
import de.tomgrill.gdxfacebook.core.GDXFacebookConfig;

public class GDXFacebookSystem {
    private static GDXFacebookSystem instance;
    private GDXFacebook facebook;
    private GDXFacebookConfig config;

    private GDXFacebookSystem(GDXFacebookConfig config) {
        this.validateConfig(config);
        this.config = config;
    }

    public static GDXFacebook install(GDXFacebookConfig config) {
        instance = new GDXFacebookSystem(config);
        instance.installSystem();
        return instance.getFacebook();
    }

    private void installSystem() {
        this.tryToLoadDesktopGDXFacebook();
        this.tryToLoadHTMLGDXFacebook();
        this.tryToLoadIOSGDXFacebook();
        this.tryToLoadAndroidGDXFacebook();
        if (this.facebook == null) {
            this.facebook = new FallbackGDXFacebook(this.config);
        }
    }

    private void tryToLoadAndroidGDXFacebook() {
        Object gdxAppObject;
        if (Gdx.app.getType() != Application.ApplicationType.Android) {
            this.showDebugSkipInstall(Application.ApplicationType.Android.name());
            return;
        }
        try {
            Class gdxClazz = ClassReflection.forName((String)"com.badlogic.gdx.Gdx");
            gdxAppObject = ClassReflection.getField((Class)gdxClazz, (String)"app").get(null);
        }
        catch (ReflectionException e) {
            throw new RuntimeException("No libGDX environment. \n");
        }
        try {
            Class gdxAndroidEventListenerClazz = ClassReflection.forName((String)"com.badlogic.gdx.backends.android.AndroidEventListener");
            Class activityClazz = ClassReflection.forName((String)"android.app.Activity");
            Class facebookClazz = ClassReflection.forName((String)"de.tomgrill.gdxfacebook.android.AndroidGDXFacebook");
            Object activity = null;
            if (ClassReflection.isAssignableFrom((Class)activityClazz, gdxAppObject.getClass())) {
                activity = gdxAppObject;
            } else {
                Class<?> supportFragmentClass = GDXFacebookSystem.findClass("android.support.v4.app.Fragment");
                if (supportFragmentClass != null && ClassReflection.isAssignableFrom(supportFragmentClass, gdxAppObject.getClass())) {
                    activity = ClassReflection.getMethod(supportFragmentClass, (String)"getActivity", (Class[])new Class[0]).invoke(gdxAppObject, new Object[0]);
                } else {
                    Class<?> fragmentClass = GDXFacebookSystem.findClass("android.app.Fragment");
                    if (fragmentClass != null && ClassReflection.isAssignableFrom(fragmentClass, gdxAppObject.getClass())) {
                        activity = ClassReflection.getMethod(fragmentClass, (String)"getActivity", (Class[])new Class[0]).invoke(gdxAppObject, new Object[0]);
                    }
                }
            }
            if (activity == null) {
                throw new RuntimeException("Can't find your gdx activity to instantiate libGDX Facebook. Looks like you have implemented AndroidApplication without using Activity or Fragment classes or Activity is not available at the moment.");
            }
            Object facebookObj = ClassReflection.getConstructor((Class)facebookClazz, (Class[])new Class[]{activityClazz, GDXFacebookConfig.class}).newInstance(new Object[]{activity, this.config});
            Method gdxAppAddAndroidEventListenerMethod = ClassReflection.getMethod(gdxAppObject.getClass(), (String)"addAndroidEventListener", (Class[])new Class[]{gdxAndroidEventListenerClazz});
            gdxAppAddAndroidEventListenerMethod.invoke(gdxAppObject, new Object[]{facebookObj});
            this.facebook = (GDXFacebook)facebookObj;
            this.showDebugInstallSuccessful(Application.ApplicationType.Android.name());
        }
        catch (ReflectionException e) {
            this.showErrorInstall(Application.ApplicationType.Android.name(), "core");
            e.printStackTrace();
        }
    }

    private void tryToLoadIOSGDXFacebook() {
        if (Gdx.app.getType() != Application.ApplicationType.iOS) {
            this.showDebugSkipInstall(Application.ApplicationType.iOS.name());
            return;
        }
        try {
            Class facebookClazz = ClassReflection.forName((String)"de.tomgrill.gdxfacebook.ios.IOSGDXFacebook");
            Object facebookObj = ClassReflection.getConstructor((Class)facebookClazz, (Class[])new Class[]{GDXFacebookConfig.class}).newInstance(new Object[]{this.config});
            this.facebook = (GDXFacebook)facebookObj;
            this.showDebugInstallSuccessful(Application.ApplicationType.iOS.name());
        }
        catch (ReflectionException e) {
            this.showErrorInstall(Application.ApplicationType.iOS.name(), "ios");
            e.printStackTrace();
        }
    }

    private void tryToLoadHTMLGDXFacebook() {
        if (Gdx.app.getType() != Application.ApplicationType.WebGL) {
            this.showDebugSkipInstall(Application.ApplicationType.WebGL.name());
            return;
        }
        try {
            Class facebookClazz = ClassReflection.forName((String)"de.tomgrill.gdxfacebook.html.HTMLGDXFacebook");
            Object facebookObj = ClassReflection.getConstructor((Class)facebookClazz, (Class[])new Class[]{GDXFacebookConfig.class}).newInstance(new Object[]{this.config});
            this.facebook = (GDXFacebook)facebookObj;
            this.showDebugInstallSuccessful(Application.ApplicationType.WebGL.name());
        }
        catch (ReflectionException e) {
            this.showErrorInstall(Application.ApplicationType.WebGL.name(), "html");
            e.printStackTrace();
        }
    }

    private void tryToLoadDesktopGDXFacebook() {
        if (Gdx.app.getType() != Application.ApplicationType.Desktop) {
            this.showDebugSkipInstall(Application.ApplicationType.Desktop.name());
            return;
        }
        try {
            Class facebookClazz = ClassReflection.forName((String)"de.tomgrill.gdxfacebook.desktop.DesktopGDXFacebook");
            Object facebookObj = ClassReflection.getConstructor((Class)facebookClazz, (Class[])new Class[]{GDXFacebookConfig.class}).newInstance(new Object[]{this.config});
            this.facebook = (GDXFacebook)facebookObj;
            this.showDebugInstallSuccessful(Application.ApplicationType.Desktop.name());
        }
        catch (ReflectionException e) {
            this.showErrorInstall(Application.ApplicationType.Desktop.name(), "desktop");
        }
    }

    private void validateConfig(GDXFacebookConfig config) {
        if (config == null) {
            throw new NullPointerException(GDXFacebookConfig.class.getSimpleName() + "may not be null.");
        }
        if (config.PREF_FILENAME == null) {
            throw new NullPointerException("GDXFacebookConfig.class.getSimpleName() + \": PREF_FILENAME may bot be null.");
        }
        if (config.PREF_FILENAME.length() == 0) {
            throw new RuntimeException(GDXFacebookConfig.class.getSimpleName() + ": PREF_FILENAME is empty.");
        }
        if (config.APP_ID == null) {
            throw new NullPointerException("GDXFacebookConfig.class.getSimpleName() + \": APP_ID may bot be null.");
        }
        Long.valueOf(config.APP_ID);
    }

    public GDXFacebook getFacebook() {
        return this.facebook;
    }

    private void showDebugSkipInstall(String os) {
        Gdx.app.debug("gdx-facebook (1.1.1)", "Skip installing gdx-facebook (1.1.1) for " + os + ". Not running " + os + ". \n");
    }

    private void showErrorInstall(String os, String artifact) {
        Gdx.app.error("gdx-facebook (1.1.1)", "Error installing gdx-facebook (1.1.1) for " + os + "\n");
        Gdx.app.error("gdx-facebook (1.1.1)", "Did you add >> compile \"de.tomgrill.gdxfacebook:gdx-facebook-" + artifact + ":" + "1.1.1" + "\" << to your gradle dependencies? View https://github.com/TomGrill/gdx-facebook/wiki for more information.\n");
    }

    private void showDebugInstallSuccessful(String os) {
        Gdx.app.debug("gdx-facebook (1.1.1)", "gdx-facebook (1.1.1) for " + os + " installed successfully.");
    }

    private static Class<?> findClass(String name) {
        try {
            return ClassReflection.forName((String)name);
        }
        catch (Exception e) {
            return null;
        }
    }
}

