/*
 * Decompiled with CFR 0.152.
 */
package de.tomgrill.gdxfacebook.core;

import com.badlogic.gdx.utils.ArrayMap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class GDXFacebookGraphRequest {
    private String url = "https://graph.facebook.com/";
    private String node = "";
    private ArrayMap<String, String> fields = new ArrayMap();
    private boolean useCurrentAccessToken = false;
    private String method = "GET";
    private int timeout = 10000;
    public static String defaultEncoding = "UTF-8";
    public static String nameValueSeparator = "=";
    public static String parameterSeparator = "&";

    public GDXFacebookGraphRequest setNode(String node) {
        this.node = node.trim();
        if (this.node.startsWith("/")) {
            this.node.replaceFirst("/", "");
        }
        return this;
    }

    public GDXFacebookGraphRequest putField(String key, String value) {
        this.fields.put((Object)key, (Object)value);
        return this;
    }

    public GDXFacebookGraphRequest putFields(ArrayMap<String, String> fields) {
        fields.putAll(fields);
        return this;
    }

    public GDXFacebookGraphRequest useCurrentAccessToken() {
        this.useCurrentAccessToken = true;
        return this;
    }

    protected boolean isUseCurrentAccessToken() {
        return this.useCurrentAccessToken;
    }

    protected String getUrl() {
        return this.url;
    }

    protected String getNode() {
        return this.node;
    }

    protected String getMethod() {
        return this.method;
    }

    public GDXFacebookGraphRequest setMethod(String method) {
        this.method = method;
        return this;
    }

    protected String getContentAsString() {
        StringBuffer convertedParameters = new StringBuffer();
        for (int i = 0; i < this.fields.size; ++i) {
            convertedParameters.append(GDXFacebookGraphRequest.encode((String)this.fields.getKeyAt(i), defaultEncoding));
            convertedParameters.append(nameValueSeparator);
            convertedParameters.append(GDXFacebookGraphRequest.encode((String)this.fields.getValueAt(i), defaultEncoding));
            convertedParameters.append(parameterSeparator);
        }
        if (convertedParameters.length() > 0) {
            convertedParameters.deleteCharAt(convertedParameters.length() - 1);
        }
        return convertedParameters.toString();
    }

    private static String encode(String content, String encoding) {
        try {
            return URLEncoder.encode(content, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected int getTimeout() {
        return this.timeout;
    }

    public GDXFacebookGraphRequest setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }
}

