/*
 * Decompiled with CFR 0.152.
 */
package de.tomgrill.gdxfacebook.core;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.net.HttpRequestBuilder;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import de.tomgrill.gdxfacebook.core.GDXFacebookAccessToken;
import de.tomgrill.gdxfacebook.core.GDXFacebookCallback;
import de.tomgrill.gdxfacebook.core.GDXFacebookConfig;
import de.tomgrill.gdxfacebook.core.GDXFacebookError;
import de.tomgrill.gdxfacebook.core.GDXFacebookGameRequest;
import de.tomgrill.gdxfacebook.core.GDXFacebookGraphRequest;
import de.tomgrill.gdxfacebook.core.GameRequestResult;
import de.tomgrill.gdxfacebook.core.JsonResult;
import de.tomgrill.gdxfacebook.core.SignInMode;
import de.tomgrill.gdxfacebook.core.SignInResult;

public abstract class GDXFacebook {
    protected GDXFacebookConfig config;
    protected Preferences preferences;
    protected GDXFacebookAccessToken accessToken;
    protected GDXFacebookCallback callback;
    protected Array<String> permissions;

    public GDXFacebook(GDXFacebookConfig config) {
        this.config = config;
        this.preferences = Gdx.app.getPreferences(config.PREF_FILENAME);
    }

    public abstract void signIn(SignInMode var1, Array<String> var2, GDXFacebookCallback<SignInResult> var3);

    public abstract void showGameRequest(GDXFacebookGameRequest var1, GDXFacebookCallback<GameRequestResult> var2);

    public GDXFacebookAccessToken getAccessToken() {
        return this.accessToken;
    }

    protected abstract void startGUISignIn();

    protected void startSilentSignIn() {
        if (this.accessToken != null) {
            Gdx.app.debug("gdx-facebook (1.1.1)", "Starting silent sign in.");
            GDXFacebookGraphRequest request = new GDXFacebookGraphRequest();
            request.setMethod("POST");
            request.setNode("");
            request.putField("batch", "[{\"method\":\"GET\", \"relative_url\":\"me\"},{\"method\":\"GET\", \"relative_url\":\"me/permissions\"}]");
            request.putField("include_headers", "false");
            request.useCurrentAccessToken();
            this.newGraphRequest(request, new GDXFacebookCallback<JsonResult>(){

                @Override
                public void onSuccess(JsonResult result) {
                    JsonValue value = result.getJsonValue();
                    if (value != null && value.isArray()) {
                        JsonValue meValue = value.get(0);
                        JsonValue permissionsValue = value.get(1);
                        if (GDXFacebook.this.jsonHasCode200AndBody(meValue) && GDXFacebook.this.jsonHasCode200AndBody(permissionsValue)) {
                            JsonReader reader = new JsonReader();
                            JsonValue permissionBodyValue = reader.parse(permissionsValue.getString("body"));
                            JsonValue permissionArray = permissionBodyValue.get("data");
                            Array grantedPermissions = new Array();
                            for (int i = 0; i < permissionArray.size; ++i) {
                                JsonValue permission = permissionArray.get(i);
                                if (!permission.getString("status").equals("granted")) continue;
                                grantedPermissions.add((Object)permission.getString("permission").toLowerCase());
                            }
                            if (this.arePermissionsGranted((Array<String>)grantedPermissions)) {
                                Gdx.app.debug("gdx-facebook (1.1.1)", "Silent sign in successful. Current token is still valid.");
                                GDXFacebook.this.callback.onSuccess(new SignInResult(GDXFacebook.this.accessToken, "Silent sign in successful. Current token is still valid."));
                            } else {
                                GDXFacebook.this.signOut();
                                Gdx.app.debug("gdx-facebook (1.1.1)", "Used access_token is valid but new permissions need to be granted. Need GUI sign in.");
                                GDXFacebook.this.callback.onError(new GDXFacebookError("Used access_token is valid but new permissions need to be granted. Need GUI sign in."));
                                GDXFacebook.this.startGUISignIn();
                            }
                        } else {
                            GDXFacebook.this.signOut();
                            Gdx.app.debug("gdx-facebook (1.1.1)", "Silent sign in error: " + value.toString());
                            GDXFacebook.this.callback.onError(new GDXFacebookError(value.toString()));
                            GDXFacebook.this.startGUISignIn();
                        }
                    } else {
                        GDXFacebook.this.callback.onError(new GDXFacebookError("Unexpected error occurred while trying to sign in. Error unknown, possible timeout."));
                    }
                }

                private boolean arePermissionsGranted(Array<String> grantedPermissions) {
                    for (int i = 0; i < GDXFacebook.this.permissions.size; ++i) {
                        if (grantedPermissions.contains((Object)((String)GDXFacebook.this.permissions.get(i)).toLowerCase(), false)) continue;
                        return false;
                    }
                    return true;
                }

                @Override
                public void onError(GDXFacebookError error) {
                    GDXFacebook.this.signOut();
                    Gdx.app.debug("gdx-facebook (1.1.1)", "Silent sign in error: " + error.getErrorMessage());
                    GDXFacebook.this.callback.onError(error);
                    GDXFacebook.this.startGUISignIn();
                }

                @Override
                public void onFail(Throwable t) {
                    GDXFacebook.this.signOut();
                    Gdx.app.debug("gdx-facebook (1.1.1)", "Silent sign in failed: " + t);
                    GDXFacebook.this.callback.onFail(t);
                    GDXFacebook.this.startGUISignIn();
                }

                @Override
                public void onCancel() {
                    GDXFacebook.this.signOut();
                    Gdx.app.debug("gdx-facebook (1.1.1)", "Silent sign in cancelled");
                    GDXFacebook.this.callback.onCancel();
                    GDXFacebook.this.startGUISignIn();
                }
            });
        } else {
            Gdx.app.debug("gdx-facebook (1.1.1)", "Silent sign in cancelled. No existing access token.");
        }
    }

    protected void storeNewToken(GDXFacebookAccessToken token) {
        Gdx.app.debug("gdx-facebook (1.1.1)", "Storing new accessToken: " + token.getToken());
        this.preferences.putString("access_token", token.getToken());
        this.preferences.putLong("expires_at", token.getExpiresAt());
        this.preferences.flush();
    }

    protected void loadAccessToken() {
        String token = this.preferences.getString("access_token", null);
        long expiresAt = this.preferences.getLong("expires_at", 0L);
        if (token != null && expiresAt > 0L) {
            Gdx.app.debug("gdx-facebook (1.1.1)", "Loaded existing accessToken: " + token);
            this.accessToken = new GDXFacebookAccessToken(token, expiresAt);
        } else {
            Gdx.app.debug("gdx-facebook (1.1.1)", "Could not load existing accessToken");
        }
    }

    public void newGraphRequest(GDXFacebookGraphRequest request, final GDXFacebookCallback<JsonResult> callback) {
        String accessToken = null;
        if (this.getAccessToken() != null) {
            accessToken = this.getAccessToken().getToken();
        }
        if (request.isUseCurrentAccessToken() && accessToken != null) {
            request.putField("access_token", accessToken);
        }
        Net.HttpRequest httpRequest = new Net.HttpRequest(request.getMethod());
        String url = request.getUrl() + this.config.GRAPH_API_VERSION + "/" + request.getNode();
        httpRequest.setUrl(url);
        httpRequest.setContent(request.getContentAsString());
        httpRequest.setTimeOut(request.getTimeout());
        HttpRequestBuilder builder = new HttpRequestBuilder().newRequest();
        builder.method(request.getMethod());
        Gdx.net.sendHttpRequest(httpRequest, new Net.HttpResponseListener(){

            public void handleHttpResponse(Net.HttpResponse httpResponse) {
                String resultString = httpResponse.getResultAsString();
                int statusCode = httpResponse.getStatus().getStatusCode();
                if (statusCode == -1) {
                    GDXFacebookError error = new GDXFacebookError("Connection time out. Consider increasing timeout value by using setTimeout()");
                    callback.onError(error);
                } else if (statusCode >= 200 && statusCode < 300) {
                    callback.onSuccess(new JsonResult(resultString));
                } else {
                    GDXFacebookError error = new GDXFacebookError("Error: " + resultString);
                    callback.onError(error);
                }
            }

            public void failed(Throwable t) {
                t.printStackTrace();
                callback.onFail(t);
            }

            public void cancelled() {
                callback.onCancel();
            }
        });
    }

    private boolean jsonHasCode200AndBody(JsonValue jsonValue) {
        return jsonValue.has("code") && jsonValue.getInt("code") == 200 && jsonValue.has("body");
    }

    public boolean isSignedIn() {
        return this.accessToken != null;
    }

    public void signOut() {
        this.signOut(true);
    }

    public void signOut(boolean keepSessionData) {
        this.accessToken = null;
    }

    public final void deleteTokenData() {
        this.preferences.remove("access_token");
        this.preferences.remove("expires_at");
        this.preferences.flush();
    }
}

