/*
 * Decompiled with CFR 0.152.
 */
package de.tomgrill.gdxdialogs.ios.dialogs;

import com.badlogic.gdx.Gdx;
import de.tomgrill.gdxdialogs.core.dialogs.GDXTextPrompt;
import de.tomgrill.gdxdialogs.core.listener.TextPromptListener;
import org.robovm.apple.foundation.NSRange;
import org.robovm.apple.uikit.UIAlertView;
import org.robovm.apple.uikit.UIAlertViewDelegate;
import org.robovm.apple.uikit.UIAlertViewDelegateAdapter;
import org.robovm.apple.uikit.UIAlertViewStyle;
import org.robovm.apple.uikit.UITextField;
import org.robovm.apple.uikit.UITextFieldDelegate;
import org.robovm.apple.uikit.UITextFieldDelegateAdapter;
import org.robovm.rt.bro.annotation.ByVal;

public class IOSGDXTextPrompt
implements GDXTextPrompt {
    private String message = "";
    private String title = "";
    private String cancelLabel = "";
    private String confirmLabel = "";
    private TextPromptListener listener;
    private UIAlertView alertView;
    private int maxLength = 16;

    public GDXTextPrompt show() {
        if (this.alertView == null) {
            throw new RuntimeException(GDXTextPrompt.class.getSimpleName() + " has not been build. Use build() before show().");
        }
        Gdx.app.debug("gdx-dialogs (1.2.1)", IOSGDXTextPrompt.class.getSimpleName() + " now shown.");
        this.alertView.show();
        return this;
    }

    public GDXTextPrompt build() {
        if (this.alertView != null) {
            this.alertView.dispose();
        }
        UIAlertViewDelegateAdapter delegate = new UIAlertViewDelegateAdapter(){

            public void didDismiss(UIAlertView alertView, long buttonIndex) {
                if (IOSGDXTextPrompt.this.listener != null) {
                    if (buttonIndex == 0L) {
                        IOSGDXTextPrompt.this.listener.cancel();
                    }
                    if (buttonIndex == 1L) {
                        UITextField textFiel = alertView.getTextField(0L);
                        IOSGDXTextPrompt.this.listener.confirm(textFiel.getText());
                    }
                }
            }

            public void clicked(UIAlertView alertView, long buttonIndex) {
            }

            public void cancel(UIAlertView alertView) {
            }

            public void willPresent(UIAlertView alertView) {
            }

            public void didPresent(UIAlertView alertView) {
            }

            public void willDismiss(UIAlertView alertView, long buttonIndex) {
            }

            public boolean shouldEnableFirstOtherButton(UIAlertView alertView) {
                return false;
            }
        };
        String[] otherButtons = new String[]{this.confirmLabel};
        this.alertView = new UIAlertView(this.title, this.message, (UIAlertViewDelegate)delegate, this.cancelLabel, otherButtons);
        this.alertView.setAlertViewStyle(UIAlertViewStyle.PlainTextInput);
        UITextField uiTextField = this.alertView.getTextField(0L);
        uiTextField.setDelegate((UITextFieldDelegate)new UITextFieldDelegateAdapter(){

            public boolean shouldChangeCharacters(UITextField textField, @ByVal NSRange nsRange, String additionalText) {
                if (textField.getText().length() + additionalText.length() > IOSGDXTextPrompt.this.maxLength) {
                    String oldText = textField.getText();
                    String newText = oldText + additionalText;
                    textField.setText(newText.substring(0, IOSGDXTextPrompt.this.maxLength));
                    return false;
                }
                return true;
            }
        });
        return this;
    }

    public GDXTextPrompt setTitle(CharSequence title) {
        this.title = (String)title;
        return this;
    }

    public GDXTextPrompt setMaxLength(int maxLength) {
        if (maxLength < 1) {
            throw new RuntimeException("Char limit must be >= 1");
        }
        this.maxLength = maxLength;
        return this;
    }

    public GDXTextPrompt setMessage(CharSequence message) {
        this.message = (String)message;
        return this;
    }

    public GDXTextPrompt setValue(CharSequence inputTip) {
        return this;
    }

    public GDXTextPrompt setCancelButtonLabel(CharSequence label) {
        this.cancelLabel = (String)label;
        return this;
    }

    public GDXTextPrompt setConfirmButtonLabel(CharSequence label) {
        this.confirmLabel = (String)label;
        return this;
    }

    public GDXTextPrompt setTextPromptListener(TextPromptListener listener) {
        this.listener = listener;
        return this;
    }

    public GDXTextPrompt dismiss() {
        if (this.alertView == null) {
            throw new RuntimeException(GDXTextPrompt.class.getSimpleName() + " has not been build. Use build() before dismiss().");
        }
        Gdx.app.debug("gdx-dialogs (1.2.1)", IOSGDXTextPrompt.class.getSimpleName() + " dismissed.");
        this.alertView.dismiss(0L, false);
        return this;
    }
}

