/*
 * Decompiled with CFR 0.152.
 */
package de.tomgrill.gdxdialogs.ios.dialogs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;
import de.tomgrill.gdxdialogs.core.dialogs.GDXButtonDialog;
import de.tomgrill.gdxdialogs.core.listener.ButtonClickListener;
import org.robovm.apple.uikit.UIAlertView;
import org.robovm.apple.uikit.UIAlertViewDelegate;
import org.robovm.apple.uikit.UIAlertViewDelegateAdapter;

public class IOSGDXButtonDialog
implements GDXButtonDialog {
    private UIAlertView alertView;
    private String title = "";
    private String message = "";
    private ButtonClickListener listener;
    private Array<CharSequence> labels = new Array();

    public GDXButtonDialog setCancelable(boolean cancelable) {
        return this;
    }

    public GDXButtonDialog show() {
        if (this.alertView == null) {
            throw new RuntimeException(GDXButtonDialog.class.getSimpleName() + " has not been build. Use build() before show().");
        }
        Gdx.app.debug("gdx-dialogs (1.2.1)", IOSGDXButtonDialog.class.getSimpleName() + " now shown.");
        this.alertView.show();
        return this;
    }

    public GDXButtonDialog dismiss() {
        if (this.alertView == null) {
            throw new RuntimeException(GDXButtonDialog.class.getSimpleName() + " has not been build. Use build() before show().");
        }
        Gdx.app.debug("gdx-dialogs (1.2.1)", IOSGDXButtonDialog.class.getSimpleName() + " dismissed.");
        this.alertView.dismiss(-1L, false);
        return this;
    }

    public GDXButtonDialog setClickListener(ButtonClickListener listener) {
        this.listener = listener;
        return this;
    }

    public GDXButtonDialog addButton(CharSequence label) {
        if (this.labels.size >= 3) {
            throw new RuntimeException("You can only have up to three buttons added.");
        }
        this.labels.add((Object)label);
        return this;
    }

    private void performClickOnButton(long buttonIndex) {
        if (this.listener != null) {
            int buttonNr = (int)buttonIndex;
            if (this.labels.size == 2) {
                buttonNr = buttonIndex == 0L ? 1 : 0;
            }
            this.listener.click(buttonNr);
        }
    }

    public GDXButtonDialog build() {
        UIAlertViewDelegateAdapter delegate = new UIAlertViewDelegateAdapter(){

            public void didDismiss(UIAlertView alertView, long buttonIndex) {
                IOSGDXButtonDialog.this.performClickOnButton(buttonIndex);
            }

            public void clicked(UIAlertView alertView, long buttonIndex) {
            }

            public void cancel(UIAlertView alertView) {
            }

            public void willPresent(UIAlertView alertView) {
            }

            public void didPresent(UIAlertView alertView) {
            }

            public void willDismiss(UIAlertView alertView, long buttonIndex) {
            }

            public boolean shouldEnableFirstOtherButton(UIAlertView alertView) {
                return false;
            }
        };
        String[] otherButtons = new String[this.labels.size - 1];
        String firstButton = (String)this.labels.get(0);
        if (this.labels.size == 2) {
            firstButton = (String)this.labels.get(1);
            otherButtons[0] = (String)this.labels.get(0);
        }
        if (this.labels.size == 3) {
            for (int i = 1; i < this.labels.size; ++i) {
                otherButtons[i - 1] = (String)this.labels.get(i);
            }
        }
        this.alertView = new UIAlertView(this.title, this.message, (UIAlertViewDelegate)delegate, firstButton, otherButtons);
        return this;
    }

    public GDXButtonDialog setMessage(CharSequence message) {
        this.message = (String)message;
        return this;
    }

    public GDXButtonDialog setTitle(CharSequence title) {
        this.title = (String)title;
        return this;
    }
}

