/*
 * Decompiled with CFR 0.152.
 */
package de.tomgrill.gdxdialogs.ios.dialogs;

import com.badlogic.gdx.Gdx;
import de.tomgrill.gdxdialogs.core.dialogs.GDXTextPrompt;
import de.tomgrill.gdxdialogs.core.listener.TextPromptListener;
import org.robovm.apple.uikit.UIAlertView;
import org.robovm.apple.uikit.UIAlertViewDelegate;
import org.robovm.apple.uikit.UIAlertViewDelegateAdapter;
import org.robovm.apple.uikit.UIAlertViewStyle;
import org.robovm.apple.uikit.UITextField;

public class IOSGDXTextPrompt
implements GDXTextPrompt {
    private String message = "";
    private String title = "";
    private String cancelLabel = "";
    private String confirmLabel = "";
    private TextPromptListener listener;
    private UIAlertView alertView;

    public GDXTextPrompt show() {
        if (this.alertView == null) {
            throw new RuntimeException(GDXTextPrompt.class.getSimpleName() + " has not been build. Use build() before show().");
        }
        Gdx.app.debug("gdx-dialogs (1.2.0)", IOSGDXTextPrompt.class.getSimpleName() + " now shown.");
        this.alertView.show();
        return this;
    }

    public GDXTextPrompt build() {
        if (this.alertView != null) {
            this.alertView.dispose();
        }
        UIAlertViewDelegateAdapter delegate = new UIAlertViewDelegateAdapter(){

            public void didDismiss(UIAlertView alertView, long buttonIndex) {
                if (IOSGDXTextPrompt.this.listener != null) {
                    if (buttonIndex == 0L) {
                        IOSGDXTextPrompt.this.listener.cancel();
                    }
                    if (buttonIndex == 1L) {
                        UITextField textFiel = alertView.getTextField(0L);
                        IOSGDXTextPrompt.this.listener.confirm(textFiel.getText());
                    }
                }
            }

            public void clicked(UIAlertView alertView, long buttonIndex) {
            }

            public void cancel(UIAlertView alertView) {
            }

            public void willPresent(UIAlertView alertView) {
            }

            public void didPresent(UIAlertView alertView) {
            }

            public void willDismiss(UIAlertView alertView, long buttonIndex) {
            }

            public boolean shouldEnableFirstOtherButton(UIAlertView alertView) {
                return false;
            }
        };
        String[] otherButtons = new String[]{this.confirmLabel};
        this.alertView = new UIAlertView(this.title, this.message, (UIAlertViewDelegate)delegate, this.cancelLabel, otherButtons);
        this.alertView.setAlertViewStyle(UIAlertViewStyle.PlainTextInput);
        return this;
    }

    public GDXTextPrompt setTitle(CharSequence title) {
        this.title = (String)title;
        return this;
    }

    public GDXTextPrompt setMessage(CharSequence message) {
        this.message = (String)message;
        return this;
    }

    public GDXTextPrompt setValue(CharSequence value) {
        return this;
    }

    public GDXTextPrompt setCancelButtonLabel(CharSequence label) {
        this.cancelLabel = (String)label;
        return this;
    }

    public GDXTextPrompt setConfirmButtonLabel(CharSequence label) {
        this.confirmLabel = (String)label;
        return this;
    }

    public GDXTextPrompt setTextPromptListener(TextPromptListener listener) {
        this.listener = listener;
        return this;
    }

    public GDXTextPrompt dismiss() {
        if (this.alertView == null) {
            throw new RuntimeException(GDXTextPrompt.class.getSimpleName() + " has not been build. Use build() before dismiss().");
        }
        Gdx.app.debug("gdx-dialogs (1.2.0)", IOSGDXTextPrompt.class.getSimpleName() + " dismissed.");
        this.alertView.dismiss(0L, false);
        return this;
    }
}

