/*
 * Decompiled with CFR 0.152.
 */
package de.tobj.junit.selenium;

import de.tobj.junit.selenium.BrowserRunner;
import de.tobj.junit.selenium.annotation.Browser;
import de.tobj.junit.selenium.annotation.Dimension;
import de.tobj.junit.selenium.annotation.RunWithBrowser;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;

public class SeleniumRunner
extends Suite {
    public SeleniumRunner(Class<?> klass) throws InitializationError {
        super(klass, SeleniumRunner.createRunners(klass));
    }

    private static List<Runner> createRunners(Class<?> klass) throws InitializationError {
        ArrayList<Runner> runners = new ArrayList<Runner>();
        RunWithBrowser runWithBrowser = SeleniumRunner.getBrowserAnnotation(klass);
        if (runWithBrowser != null) {
            for (Browser browser : runWithBrowser.browser()) {
                for (Dimension d : runWithBrowser.dimensions()) {
                    runners.add((Runner)new BrowserRunner(klass, browser, new org.openqa.selenium.Dimension(d.width(), d.height())));
                }
            }
        }
        return runners;
    }

    private static RunWithBrowser getBrowserAnnotation(Class<? extends Object> startClass) {
        RunWithBrowser runWithBrowser = startClass.getAnnotation(RunWithBrowser.class);
        if (runWithBrowser != null) {
            return runWithBrowser;
        }
        Class<? extends Object> parentClass = startClass.getSuperclass();
        if (parentClass != null) {
            return SeleniumRunner.getBrowserAnnotation(parentClass);
        }
        return null;
    }
}

