/*
 * Decompiled with CFR 0.152.
 */
package de.tobj.junit.selenium;

import de.tobj.junit.selenium.SeleniumRunner;
import de.tobj.junit.selenium.annotation.Browser;
import de.tobj.junit.selenium.annotation.InjectSelenium;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

@RunWith(value=SeleniumRunner.class)
public abstract class SeleniumBase
extends TestCase {
    @InjectSelenium
    private Browser browser;
    @InjectSelenium
    private Dimension dimension;
    private DesiredCapabilities desiredCapabilities;
    private WebDriver driver;
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void failed(Throwable e, Description description) {
            super.failed(e, description);
            if (SeleniumBase.this.driver == null) {
                return;
            }
            String fileName = (description.getClassName() + "_" + description.getMethodName()).replaceAll("\\.", "_");
            String file = System.getProperty("test_attachments", "target/test-attachments") + File.separator + fileName;
            try {
                FileUtils.copyFile((File)((File)((TakesScreenshot)SeleniumBase.this.driver).getScreenshotAs(OutputType.FILE)), (File)new File(file + ".png"));
            }
            catch (IOException | WebDriverException e1) {
                try {
                    PrintStream ps = new PrintStream(new File(file + ".txt"));
                    e1.printStackTrace(ps);
                    ps.close();
                }
                catch (FileNotFoundException e2) {
                    System.err.println(e1);
                    System.err.println(e2);
                }
            }
        }

        protected void finished(Description description) {
            super.finished(description);
            if (SeleniumBase.this.driver != null) {
                SeleniumBase.this.driver.quit();
            }
        }
    };

    public WebDriver driver() {
        return this.driver;
    }

    @Before
    public void setup() throws MalformedURLException {
        File nullDat;
        Assert.assertNotNull((String)"browser is null, injection failed?", (Object)((Object)this.browser));
        Assert.assertNotNull((String)"browser dimension is null, injection failed?", (Object)this.dimension);
        this.desiredCapabilities = this.modifyDesiredCapabilities(this.browser.desiredCapabilities());
        this.driver = new Augmenter().augment((WebDriver)new RemoteWebDriver(new URL(System.getProperty("remote_driver", "http://localhost:4444/wd/hub")), (Capabilities)this.desiredCapabilities));
        this.driver.manage().window().setSize(this.dimension);
        File folder = new File(System.getProperty("test_attachments", "target/test-attachments"));
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(nullDat = new File(folder, "null.dat")).exists()) {
            try {
                nullDat.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public DesiredCapabilities modifyDesiredCapabilities(DesiredCapabilities desiredCapabilities) {
        return desiredCapabilities;
    }
}

