/*
 * Decompiled with CFR 0.152.
 */
package de.tobj.junit.selenium;

import com.google.common.base.Function;
import de.tobj.junit.selenium.IURL;
import de.tobj.junit.selenium.exception.ElementNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class Helper {
    public static void alertAccept(WebDriver driver) {
        Helper.wait(100);
        driver.switchTo().alert().accept();
    }

    public static void alertDismiss(WebDriver driver) {
        Helper.wait(100);
        driver.switchTo().alert().dismiss();
    }

    public static void click(WebDriver driver, WebElement element) {
        element.click();
        Helper.waitForLoad(driver, 30);
    }

    public static void navigateTo(WebDriver driver, WebElement element) {
        Helper.click(driver, element);
        Helper.wait(500);
    }

    public static void scrollTo(WebDriver driver, WebElement element) {
        Actions actions = new Actions(driver);
        actions.moveToElement(element);
        actions.perform();
    }

    public static void scrollTo(WebDriver driver, By by) throws ElementNotFoundException {
        Helper.scrollTo(driver, Helper.findElement(driver, by));
    }

    public static void selectOptionByValue(WebDriver driver, By by, String value) throws ElementNotFoundException {
        Select select = new Select(Helper.findElement(driver, by));
        select.selectByValue(value);
    }

    public static void submit(WebDriver driver, WebElement element) {
        element.submit();
        Helper.waitForLoad(driver, 30);
    }

    public static WebElement randomOption(Select select) {
        int oldValue = Integer.parseInt(Helper.getValue(select.getFirstSelectedOption()));
        for (WebElement option : select.getOptions()) {
            int currentValue = Integer.parseInt(Helper.getValue(option));
            if (oldValue == currentValue) continue;
            select.selectByIndex(currentValue);
            return option;
        }
        return null;
    }

    public static WebElement findElement(WebDriver driver, By by) throws ElementNotFoundException {
        try {
            return driver.findElement(by);
        }
        catch (NoSuchElementException ex) {
            throw new ElementNotFoundException(by, driver.getCurrentUrl(), ex);
        }
    }

    public static List<WebElement> findElements(WebDriver driver, By by) throws ElementNotFoundException {
        return Helper.findElements(driver, by, true);
    }

    public static List<WebElement> findElements(WebDriver driver, By by, boolean testIsEmpty) throws ElementNotFoundException {
        List elements = driver.findElements(by);
        if (testIsEmpty && elements.isEmpty()) {
            throw new ElementNotFoundException(by, driver.getCurrentUrl());
        }
        return elements;
    }

    public static String getClassBy(WebDriver driver, By by) throws ElementNotFoundException {
        return Helper.findElement(driver, by).getAttribute("class");
    }

    public static String getTextBy(WebDriver driver, By by) throws ElementNotFoundException {
        return Helper.findElement(driver, by).getText();
    }

    public static String getValueBy(WebDriver driver, By by) throws ElementNotFoundException {
        return Helper.getValue(Helper.findElement(driver, by));
    }

    public static String getValue(WebElement element) {
        return element.getAttribute("value");
    }

    public static void wait(int timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void waitForJQuery(WebDriver driver, int timeout) {
        new WebDriverWait(driver, (long)timeout).until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                JavascriptExecutor js = (JavascriptExecutor)driver;
                return (Boolean)js.executeScript("return jQuery.active == 0", new Object[0]);
            }
        });
    }

    public static void waitForLoad(WebDriver driver, int timeout) {
        new WebDriverWait(driver, (long)timeout).until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return ((JavascriptExecutor)driver).executeScript("return document.readyState", new Object[0]).equals("complete");
            }
        });
        Helper.wait(250);
    }

    public static String getParamFromUrl(WebDriver driver, String key) {
        try {
            List params = URLEncodedUtils.parse((URI)new URI(driver.getCurrentUrl()), (String)"UTF-8");
            for (NameValuePair param : params) {
                if (!param.getName().equalsIgnoreCase(key)) continue;
                return param.getValue();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public static String getUrlWithPath(String domain, IURL url) {
        String urlString = Helper.getUrlWithPath(domain, url.getPath());
        try {
            return new URI(urlString).normalize().toURL().toString();
        }
        catch (Exception e) {
            throw new IllegalStateException("URI Path not valid! Used domain: " + urlString, e);
        }
    }

    public static String getUrlWithPath(String domain, String urlpath) {
        StringBuilder urlString = new StringBuilder(domain);
        if (StringUtils.isNotBlank((CharSequence)urlpath)) {
            if (urlString.charAt(urlString.length() - 1) != '/' && urlpath.charAt(0) != '/') {
                urlString = urlString.append("/");
            }
            urlString = urlString.append(urlpath.startsWith("/") ? urlpath.substring(1) : urlpath);
        }
        return urlString.toString();
    }

    public static boolean matchesUrl(WebDriver driver, String domain, IURL url) {
        Pattern p = Pattern.compile(Helper.getUrlWithPath(domain, url.getPath()));
        Matcher m = p.matcher(driver.getCurrentUrl());
        return m.matches();
    }
}

