/*
 * Decompiled with CFR 0.152.
 */
package de.tobj.junit.selenium;

import de.tobj.junit.selenium.annotation.Browser;
import de.tobj.junit.selenium.annotation.InjectSelenium;
import de.tobj.junit.selenium.annotation.RunWithBrowser;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.openqa.selenium.Dimension;

public class BrowserRunner
extends BlockJUnit4ClassRunner {
    private Browser browser;
    private Dimension dimension;

    public BrowserRunner(Class<?> klass, Browser browser, Dimension dimension) throws InitializationError {
        super(klass);
        this.browser = browser;
        this.dimension = dimension;
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        BrowserRunner.inject(target, (Object)this.browser);
        BrowserRunner.inject(target, this.dimension);
        return super.withBefores(method, target, statement);
    }

    private static void inject(Object target, Object toInject) {
        for (Field field : BrowserRunner.getFields(target.getClass())) {
            if (!field.getType().isAssignableFrom(toInject.getClass())) continue;
            try {
                field.setAccessible(true);
                field.set(target, toInject);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static List<Field> getFields(Class<? extends Object> startClass) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Field field : startClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(InjectSelenium.class)) continue;
            fields.add(field);
        }
        Class<? extends Object> parentClass = startClass.getSuperclass();
        if (parentClass != null) {
            fields.addAll(BrowserRunner.getFields(parentClass));
        }
        return fields;
    }

    protected List<FrameworkMethod> getChildren() {
        LinkedList<FrameworkMethod> methods = new LinkedList<FrameworkMethod>();
        for (FrameworkMethod method : super.getChildren()) {
            RunWithBrowser runWithBrowser = (RunWithBrowser)method.getAnnotation(RunWithBrowser.class);
            if (runWithBrowser == null || runWithBrowser.browser() == null) {
                methods.add(method);
                continue;
            }
            for (Browser browser : runWithBrowser.browser()) {
                if (this.browser != browser) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    protected String testName(FrameworkMethod method) {
        return this.generateTestName(method.getName());
    }

    protected String getName() {
        return this.generateTestName(super.getName());
    }

    private String generateTestName(String name) {
        return String.format("[%s]_[%sx%s]_%s", this.browser.desiredCapabilities().getBrowserName(), this.dimension.getWidth(), this.dimension.getHeight(), name);
    }
}

