/*
 * Decompiled with CFR 0.152.
 */
package de.tobj.junit.selenium;

import de.tobj.junit.selenium.Helper;
import de.tobj.junit.selenium.IURL;
import de.tobj.junit.selenium.exception.ElementNotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Assert
extends org.junit.Assert {
    public static void assertBlank(WebDriver driver, By by) {
        Assert.assertBlank(driver, by, "text is not blank for element '" + by.toString() + "'");
    }

    public static void assertBlank(WebDriver driver, By by, String message) {
        try {
            Assert.assertTrue((String)message, (boolean)StringUtils.isBlank((CharSequence)Helper.getTextBy(driver, by)));
        }
        catch (ElementNotFoundException e) {
            Assert.assertTrue((String)String.format("%s", ExceptionUtils.getMessage((Throwable)e)), (boolean)false);
        }
    }

    public static void assertElementIsPresent(WebDriver driver, By by, String errorMessage) {
        try {
            Helper.findElement(driver, by);
            Assert.assertTrue((boolean)true);
        }
        catch (ElementNotFoundException | NoSuchElementException ex) {
            Assert.assertTrue((String)String.format("%s (%s)", errorMessage, ExceptionUtils.getMessage((Throwable)ex)), (boolean)false);
        }
    }

    public static void assertElementNotPresent(WebDriver driver, By by, String errorMessage) {
        try {
            Helper.findElement(driver, by);
            Assert.assertTrue((String)errorMessage, (boolean)false);
        }
        catch (ElementNotFoundException | NoSuchElementException ex) {
            Assert.assertTrue((boolean)true);
        }
    }

    public static void assertElementIsVisible(WebDriver driver, By by, String errorMessage) {
        try {
            WebElement element = Helper.findElement(driver, by);
            Assert.assertTrue((String)errorMessage, (boolean)element.isDisplayed());
        }
        catch (ElementNotFoundException e) {
            Assert.assertTrue((String)ExceptionUtils.getMessage((Throwable)e), (boolean)false);
        }
    }

    public static void assertElementNotVisible(WebDriver driver, By by, String errorMessage) throws ElementNotFoundException {
        WebElement element = Helper.findElement(driver, by);
        Assert.assertFalse((String)errorMessage, (boolean)element.isDisplayed());
    }

    public static void assertNotBlank(WebDriver driver, By by) throws ElementNotFoundException {
        Assert.assertNotBlank(driver, by, "text is blank for element '" + by.toString() + "'");
    }

    public static void assertNotBlank(WebDriver driver, By by, String message) throws ElementNotFoundException {
        Assert.assertTrue((String)message, (boolean)StringUtils.isNotBlank((CharSequence)Helper.getTextBy(driver, by)));
    }

    public static void assertUrl(WebDriver driver, String domain, IURL url) {
        Helper.wait(200);
        String str = String.format("current url is not same as expected. current url: '%s';  expected url: '%s'", driver.getCurrentUrl(), Helper.getUrlWithPath(domain, url.getPath()));
        Assert.assertTrue((String)str, (boolean)Helper.matchesUrl(driver, domain, url));
    }
}

