package de.tobj.http.simplerequest;

import de.tobj.http.simplerequest.exception.ConnectorException;
import de.tobj.http.simplerequest.exception.ParserException;
import de.tobj.http.simplerequest.exception.StatusCodeException;

/**
 * SimpleHTTPRequest
 */
public class SimpleHTTPRequest extends AbstractHTTPRequest {

	/**
	 * Constructor with no baseUrl
	 */
	public SimpleHTTPRequest() {
		super();
	}

	/**
	 * Constructor
	 * 
	 * @param url
	 */
	public SimpleHTTPRequest(String url) {
		super(url);
	}

	/**
	 * send request
	 * 
	 * @param request
	 * @return SimpleResult
	 * @throws ConnectorException
	 * @throws ParserException
	 * @throws StatusCodeException
	 */
	public SimpleResult request(Request request) throws ConnectorException, ParserException, StatusCodeException {
		return sendRequest(request, new SimpleResult());
	}

	/**
	 * parse response
	 * 
	 * @param response
	 * @param result
	 * @return
	 * @throws ParserException
	 */
	@SuppressWarnings("unchecked")
	@Override
	public <R extends Result> R parseResponse(StringBuilder response, R result) throws ParserException {
		return (R) new SimpleResult(response);
	}
}