package de.tobj.http.simplerequest;

import java.util.List;

import org.apache.http.NameValuePair;

import de.tobj.http.simplerequest.request.Method;

/**
 * Interface used as an abstraction for the request
 *
 * Implementations use their own endpoint with custom parameter
 */
public interface Request {

	/**
	 * @return endpoint
	 */
	public abstract String getEndpointUrl();

	/**
	 * HTTP-Method used to request
	 *
	 * @return httpMethod
	 */
	public abstract Method getHttpMethod();

	/**
	 * HTTP-Parameter used for the request
	 *
	 * @return list of key-value-pairs
	 */
	public abstract List<NameValuePair> getHttpParams();
}