/*
 * Decompiled with CFR 0.152.
 */
package de.tisoft.rsyntaxtextarea.modes.antlr;

import de.tisoft.rsyntaxtextarea.modes.antlr.AlwaysThrowingErrorListener;
import de.tisoft.rsyntaxtextarea.modes.antlr.ModeInfoManager;
import de.tisoft.rsyntaxtextarea.modes.antlr.MultiLineTokenInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.text.Segment;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Token;
import org.fife.ui.rsyntaxtextarea.TokenMakerBase;

public abstract class AntlrTokenMaker
extends TokenMakerBase {
    private final ModeInfoManager modeInfoManager = new ModeInfoManager();
    private final List<MultiLineTokenInfo> multiLineTokenInfos;

    protected AntlrTokenMaker(MultiLineTokenInfo ... multiLineTokenInfos) {
        this.multiLineTokenInfos = Arrays.asList(multiLineTokenInfos);
    }

    public int getClosestStandardTokenTypeForInternalType(int type) {
        if (type == 0) {
            return 35;
        }
        if (type < 0) {
            return this.modeInfoManager.getModeInfo((int)type).tokenType;
        }
        return this.convertType(type);
    }

    protected abstract int convertType(int var1);

    public org.fife.ui.rsyntaxtextarea.Token getTokenList(Segment text, int initialTokenType, int startOffset) {
        Lexer lexer;
        ModeInfoManager.ModeInfo modeInfo;
        block11: {
            String multilineTokenEnd;
            String line = text.toString();
            this.resetTokenList();
            modeInfo = this.modeInfoManager.getModeInfo(initialTokenType);
            this.setLanguageIndex(modeInfo.currentMode);
            String multilineTokenStart = this.getMultilineTokenStart(modeInfo);
            if (multilineTokenStart != null) {
                line = multilineTokenStart + line;
            }
            if ((multilineTokenEnd = this.getMultilineTokenEnd(line)) != null) {
                line = line + multilineTokenEnd;
            }
            lexer = this.createLexer(line);
            for (int mode : modeInfo.modeStack.toArray()) {
                lexer.pushMode(mode);
            }
            lexer.mode(modeInfo.currentMode);
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)new AlwaysThrowingErrorListener());
            int currentArrayOffset = text.getBeginIndex();
            int currentDocumentOffset = startOffset;
            try {
                while (true) {
                    Token at = lexer.nextToken();
                    this.setLanguageIndex(lexer._mode);
                    if (at.getType() == -1) {
                        if (multilineTokenEnd == null) {
                            this.addNullToken();
                        }
                        break;
                    }
                    this.addToken(text, currentArrayOffset, currentDocumentOffset, multilineTokenStart, multilineTokenEnd, at);
                    currentArrayOffset = this.currentToken.textOffset + this.currentToken.textCount;
                    currentDocumentOffset = this.currentToken.getEndOffset();
                }
            }
            catch (AlwaysThrowingErrorListener.AntlrException exceptionInstanceNotNeeded) {
                String remainingText = String.valueOf(text.array, currentArrayOffset, text.offset - currentArrayOffset + text.count);
                int type = multilineTokenStart != null ? modeInfo.tokenType : 35;
                this.addToken(text, currentArrayOffset, currentArrayOffset + remainingText.length() - 1, type, currentDocumentOffset);
                if (multilineTokenStart != null) break block11;
                this.addNullToken();
            }
        }
        if (this.firstToken == null) {
            this.addNullToken();
        }
        if (this.firstToken.getType() == 0 && this.firstToken == this.currentToken) {
            this.firstToken.setType(modeInfo.tokenType);
            this.firstToken.text = new char[0];
            this.firstToken.textCount = 0;
        }
        if (!lexer._modeStack.isEmpty() || lexer._mode != 0) {
            this.currentToken.setType(this.modeInfoManager.storeModeInfo(this.currentToken.getType(), lexer._mode, lexer._modeStack));
        }
        return this.firstToken;
    }

    private void addToken(Segment text, int start, int startOffset, String multilineTokenStart, String multilineTokenEnd, Token at) {
        this.addToken(text, start, this.calculateTokenEnd(multilineTokenStart, multilineTokenEnd, start, at), this.getClosestStandardTokenTypeForInternalType(at.getType()), startOffset);
    }

    private int calculateTokenEnd(String multilineTokenStart, String multilineTokenEnd, int currentArrayOffset, Token at) {
        int end = currentArrayOffset + at.getText().length() - 1;
        if (multilineTokenStart != null && at.getText().startsWith(multilineTokenStart)) {
            end -= multilineTokenStart.length();
        }
        if (multilineTokenEnd != null && at.getText().endsWith(multilineTokenEnd)) {
            end -= multilineTokenEnd.length();
        }
        return end;
    }

    private String getMultilineTokenStart(ModeInfoManager.ModeInfo modeInfo) {
        return this.getMultiLineTokenInfo(this.getLanguageIndex(), modeInfo.tokenType).map(i -> i.tokenStart).orElse(null);
    }

    private String getMultilineTokenEnd(String line) {
        return this.multiLineTokenInfos.stream().filter(i -> i.languageIndex == this.getLanguageIndex()).filter(i -> line.contains(i.tokenStart)).filter(i -> line.indexOf(i.tokenEnd, line.indexOf(i.tokenStart) + i.tokenStart.length()) == -1).map(i -> i.tokenEnd).findFirst().orElse(null);
    }

    private Optional<MultiLineTokenInfo> getMultiLineTokenInfo(int languageIndex, int token) {
        return this.multiLineTokenInfos.stream().filter(i -> i.languageIndex == languageIndex).filter(i -> i.token == token).findFirst();
    }

    protected abstract Lexer createLexer(String var1);
}

