/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.rest2typescript;

import de.thomas_oster.rest2typescript.TabWriter;
import de.thomas_oster.rest2typescript.annotations.ToTypescript;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.plexus.util.StringUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;

public class Generator {
    private static final Map<Class, String> toTypescriptType = new LinkedHashMap<Class, String>();
    private final Set<String> written = new LinkedHashSet<String>();
    private final Queue<Class> toWrite = new LinkedList<Class>();
    private static final Set<String> nullableAnnotations;

    private static String name2typescript(Class c) {
        return c.getSimpleName();
    }

    String toTypescriptType(Type gtype) {
        if (gtype instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)gtype;
            if (pType.getRawType() instanceof Class && Collection.class.isAssignableFrom((Class)pType.getRawType())) {
                return this.toTypescriptType(pType.getActualTypeArguments()[0]) + "[]";
            }
        } else if (gtype instanceof Class) {
            Class type = (Class)gtype;
            if (type.isArray()) {
                return this.toTypescriptType(type.getComponentType()) + "[]";
            }
            String result = toTypescriptType.get(type);
            if (result != null) {
                return result;
            }
            this.toWrite.add(type);
            return Generator.name2typescript(type);
        }
        return "any";
    }

    private Stream<Method> sorted(Method[] m) {
        return Arrays.stream(m).sorted(Comparator.comparing(Method::getName));
    }

    private boolean hasNullableAnnotation(Method m) {
        return Arrays.stream(m.getAnnotations()).anyMatch(a -> nullableAnnotations.contains(a.annotationType().getCanonicalName()));
    }

    void writeInterface(Class iface, TabWriter out) {
        String typeName = Generator.name2typescript(iface);
        if (iface.isEnum()) {
            out.println("export type " + typeName + " = " + Arrays.stream(iface.getEnumConstants()).map(o -> '\"' + o.toString() + '\"').collect(Collectors.joining(" | ")));
            out.println("export const " + typeName + "Constants: " + typeName + "[] = [" + Arrays.stream(iface.getEnumConstants()).map(o -> '\"' + o.toString() + '\"').collect(Collectors.joining(", ")) + "];");
            return;
        }
        out.println("export interface " + Generator.name2typescript(iface) + " {").addTab();
        LinkedHashSet written = new LinkedHashSet();
        this.sorted(iface.getMethods()).forEach(m -> {
            boolean isNullable;
            String type;
            String n;
            String name = m.getName();
            if (!name.equals("getClass") && name.startsWith("get")) {
                n = StringUtils.uncapitalise((String)name.substring(3));
                type = this.toTypescriptType(m.getGenericReturnType());
                if (written.contains(n)) {
                    return;
                }
                written.add(n);
                isNullable = this.hasNullableAnnotation((Method)m);
                out.println(n + ": " + type + (isNullable ? " | null " : ""));
            }
            if (name.startsWith("is") && "boolean".equals(toTypescriptType.get(m.getReturnType()))) {
                n = StringUtils.uncapitalise((String)name.substring(2));
                type = this.toTypescriptType(m.getGenericReturnType());
                if (written.contains(n)) {
                    return;
                }
                written.add(n);
                isNullable = this.hasNullableAnnotation((Method)m);
                out.println(n + ": " + type + (isNullable ? " | null " : ""));
            }
        });
        out.removeTab().println("}");
    }

    MappingInfo getRequestMappingPath(Method m) {
        for (Annotation aa : m.getAnnotations()) {
            try {
                if (aa.annotationType().getCanonicalName().equals("org.springframework.web.bind.annotation.RequestMapping") || aa.annotationType().getCanonicalName().equals("org.springframework.web.bind.annotation.GetMapping")) {
                    String[] path = (String[])aa.getClass().getMethod("value", new Class[0]).invoke((Object)aa, new Object[0]);
                    MappingInfo result = new MappingInfo();
                    result.isPost = false;
                    if (path == null || path.length == 0) {
                        result.path = m.getName();
                        return result;
                    }
                    result.path = path[0];
                    return result;
                }
                if (!aa.annotationType().getCanonicalName().equals("org.springframework.web.bind.annotation.PostMapping")) continue;
                String[] path = (String[])aa.getClass().getMethod("value", new Class[0]).invoke((Object)aa, new Object[0]);
                MappingInfo result = new MappingInfo();
                result.isPost = true;
                if (path == null || path.length == 0) {
                    result.path = m.getName();
                    return result;
                }
                result.path = path[0];
                return result;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                Logger.getLogger(Generator.class.getName()).log(Level.SEVERE, null, e);
            }
        }
        return null;
    }

    boolean hasNullableAnnotation(Parameter p) {
        for (Annotation a : p.getAnnotations()) {
            if (!a.annotationType().getCanonicalName().equals("javax.annotation.Nullable")) continue;
            return true;
        }
        return false;
    }

    void writeController(Class controller, TabWriter out) {
        out.println("export let " + Generator.name2typescript(controller) + " = {").addTab();
        this.sorted(controller.getMethods()).forEach(m -> {
            MappingInfo mi = this.getRequestMappingPath((Method)m);
            if (mi == null || mi.path == null) {
                return;
            }
            String rt = this.toTypescriptType(m.getGenericReturnType());
            out.print(m.getName() + ": function(");
            out.print(Arrays.stream(m.getParameters()).map(p -> {
                String pt = this.toTypescriptType(p.getParameterizedType());
                boolean isNullable = this.hasNullableAnnotation((Parameter)p);
                return p.getName() + ": " + pt + (isNullable ? " | null " : "");
            }).collect(Collectors.joining(",")));
            out.print("): ");
            if (m.getReturnType() != Void.TYPE) {
                out.print("Promise<" + rt + ">");
            } else {
                out.print("void");
            }
            out.println("{").addTab();
            if (mi.isPost) {
                out.println("return new Promise((resolve,reject) => {$.ajax({").addTab().println("type: \"POST\",").println("url: \"" + mi.path + "\",").print("data: ");
                if (m.getParameters().length == 0) {
                    out.println("{},");
                } else if (m.getParameters().length == 1) {
                    out.println("JSON.stringify(" + m.getParameters()[0].getName() + "),");
                }
                out.println("contentType: \"application/json; charset=utf-8\",").println("dataType: \"json\",").println("success: resolve,").println("error: reject").println("}");
                out.removeTab().println(");");
            } else {
                out.println("return new Promise((resolve,reject) => {$.getJSON(").addTab().println("\"" + mi.path + "\",");
                out.println("{").addTab();
                out.println(Arrays.stream(m.getParameters()).sorted(Comparator.comparing(Parameter::getName)).map(p -> p.getName() + ": " + p.getName()).collect(Collectors.joining(",")));
                out.removeTab().println("},").println("resolve");
                out.removeTab().println(").fail(reject);");
            }
            out.removeTab().println("});},");
        });
        out.removeTab().println("};");
        this.writeRemainingTypes(out);
    }

    private void writeRemainingTypes(TabWriter out) {
        while (!this.toWrite.isEmpty()) {
            Class first = this.toWrite.poll();
            if (this.written.contains(Generator.name2typescript(first))) continue;
            this.writeInterface(first, out);
            this.written.add(Generator.name2typescript(first));
        }
    }

    public void generate(String sPackage, File target) throws IOException {
        this.generate(new Reflections(sPackage, new Scanner[0]), target);
    }

    private List<Class<?>> sorted(Set<Class<?>> o) {
        LinkedList result = new LinkedList(o);
        result.sort((a, b) -> a.getCanonicalName().compareTo(b.getCanonicalName()));
        return result;
    }

    public void generate(Reflections reflections, File target) throws FileNotFoundException, IOException {
        TabWriter out = new TabWriter(new PrintWriter(new OutputStreamWriter(new FileOutputStream(target))));
        out.println("/// <reference path=\"node_modules/@types/jquery/index.d.ts\" />;");
        this.toWrite.addAll(this.sorted(reflections.getTypesAnnotatedWith(ToTypescript.class)));
        this.writeRemainingTypes(out);
        Set annotated = reflections.getTypesAnnotatedWith(Controller.class);
        annotated.addAll(this.sorted(reflections.getTypesAnnotatedWith(RestController.class)));
        for (Class<?> controller : this.sorted(annotated)) {
            this.writeController(controller, out);
        }
        out.close();
    }

    public static void main(String[] args) throws IOException {
        new Generator().generate(args[0], new File(args[1]));
    }

    static {
        toTypescriptType.put(String.class, "string");
        toTypescriptType.put(Integer.class, "number");
        toTypescriptType.put(Integer.TYPE, "number");
        toTypescriptType.put(Double.class, "number");
        toTypescriptType.put(Double.TYPE, "number");
        toTypescriptType.put(Float.class, "number");
        toTypescriptType.put(Float.TYPE, "number");
        toTypescriptType.put(Short.class, "number");
        toTypescriptType.put(Short.TYPE, "number");
        toTypescriptType.put(Long.class, "number");
        toTypescriptType.put(Long.TYPE, "number");
        toTypescriptType.put(BigDecimal.class, "number");
        toTypescriptType.put(BigInteger.class, "number");
        toTypescriptType.put(Void.class, "void");
        toTypescriptType.put(Void.TYPE, "void");
        toTypescriptType.put(Boolean.class, "boolean");
        toTypescriptType.put(Boolean.TYPE, "boolean");
        nullableAnnotations = Set.of("javax.annotation.Nullable");
    }

    private static class MappingInfo {
        String path;
        boolean isPost;

        private MappingInfo() {
        }
    }
}

