/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.rest2typescript;

import de.thomas_oster.rest2typescript.Generator;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, requiresDependencyResolution=ResolutionScope.TEST)
public class Rest2TypescriptPlugin
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> projectClasspathElements;
    @Parameter(defaultValue="src/main/resources/META-INF/resources/ts/javatypes.ts")
    private File generatedFile;
    @Parameter(defaultValue="/// <reference path=\"node_modules/@types/jquery/index.d.ts\" />;")
    private String customHeader;

    public void execute() throws MojoExecutionException {
        try {
            List<String> compileSourceOutputs = Collections.singletonList(this.project.getBuild().getOutputDirectory());
            URL[] sourceFiles = this.buildMavenClasspath(compileSourceOutputs);
            URL[] projectClasspath = this.buildMavenClasspath(this.projectClasspathElements);
            URLClassLoader projectClassloader = new URLClassLoader(projectClasspath);
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(sourceFiles).addClassLoaders(new ClassLoader[]{projectClassloader}).setScanners(new Scanner[]{new MethodAnnotationsScanner(), new TypeAnnotationsScanner(), new SubTypesScanner()}));
            this.getLog().info((CharSequence)("Generating typescript to " + this.generatedFile.getAbsolutePath()));
            Generator g = new Generator();
            g.generate(reflections, this.generatedFile, this.customHeader);
        }
        catch (Throwable e) {
            throw new MojoExecutionException("A fatal error occurred while generating Typescript, see stack trace for details.", e);
        }
    }

    protected URL[] buildMavenClasspath(List<String> classpathElements) throws MojoExecutionException {
        ArrayList<URL> projectClasspathList = new ArrayList<URL>();
        for (String element : classpathElements) {
            try {
                projectClasspathList.add(new File(element).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException(element + " is an invalid classpath element", (Exception)e);
            }
        }
        return projectClasspathList.toArray(new URL[projectClasspathList.size()]);
    }
}

