/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.rest2typescript;

import de.thomas_oster.rest2typescript.TabWriter;
import de.thomas_oster.rest2typescript.annotations.ToTypescript;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.codehaus.plexus.util.StringUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class Generator {
    private static final Map<Class, String> toTypescriptType = new LinkedHashMap<Class, String>();
    private final Set<Class> written = new LinkedHashSet<Class>();
    private final Queue<Class> toWrite = new LinkedList<Class>();

    private static String name2typescript(Class c) {
        return c.getSimpleName();
    }

    String toTypescriptType(Type gtype) {
        if (gtype instanceof ParameterizedTypeImpl) {
            ParameterizedTypeImpl pType = (ParameterizedTypeImpl)gtype;
            if (Collection.class.isAssignableFrom((Class<?>)pType.getRawType())) {
                return this.toTypescriptType(pType.getActualTypeArguments()[0]) + "[]";
            }
        } else if (gtype instanceof Class) {
            Class type = (Class)gtype;
            if (type.isArray()) {
                return this.toTypescriptType(type.getComponentType()) + "[]";
            }
            String result = toTypescriptType.get(type);
            if (result != null) {
                return result;
            }
            this.toWrite.add(type);
            return Generator.name2typescript(type);
        }
        return "any";
    }

    private Stream<Method> sorted(Method[] m) {
        return Arrays.stream(m).sorted(Comparator.comparing(Method::getName));
    }

    void writeInterface(Class iface, TabWriter out) {
        out.println("export interface " + Generator.name2typescript(iface) + " {").addTab();
        this.sorted(iface.getMethods()).forEach(m -> {
            String type;
            String n;
            String name = m.getName();
            if (!name.equals("getClass") && name.startsWith("get")) {
                n = StringUtils.uncapitalise((String)name.substring(3));
                type = this.toTypescriptType(m.getGenericReturnType());
                out.println(n + ": " + type);
            }
            if (name.startsWith("is") && "boolean".equals(toTypescriptType.get(m.getReturnType()))) {
                n = StringUtils.uncapitalise((String)name.substring(2));
                type = this.toTypescriptType(m.getGenericReturnType());
                out.println(n + ": " + type);
            }
        });
        out.removeTab().println("}");
    }

    String getRequestMappingPath(Method m) {
        for (Annotation aa : m.getAnnotations()) {
            try {
                if (!aa.annotationType().getCanonicalName().equals("org.springframework.web.bind.annotation.RequestMapping") && !aa.annotationType().getCanonicalName().equals("org.springframework.web.bind.annotation.GetMapping")) continue;
                String[] path = (String[])aa.getClass().getMethod("value", new Class[0]).invoke((Object)aa, new Object[0]);
                if (path == null || path.length == 0) {
                    return m.getName();
                }
                return path[0];
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                Logger.getLogger(Generator.class.getName()).log(Level.SEVERE, null, e);
            }
        }
        return null;
    }

    void writeController(Class controller, TabWriter out) {
        out.println("export let " + Generator.name2typescript(controller) + " = {").addTab();
        this.sorted(controller.getMethods()).forEach(m -> {
            String path = this.getRequestMappingPath((Method)m);
            if (path == null) {
                return;
            }
            String rt = this.toTypescriptType(m.getGenericReturnType());
            out.print(m.getName() + ": function(");
            for (Parameter p2 : m.getParameters()) {
                String pt = this.toTypescriptType(p2.getParameterizedType());
                out.print(p2.getName() + ": " + pt + ",");
            }
            out.print("success: (");
            if (m.getReturnType() != Void.TYPE) {
                out.print("result: " + rt);
            }
            out.print(")=> void");
            out.println("){").addTab();
            out.println("return $.getJSON(").addTab().println("\"" + path + "\",");
            out.println("{").addTab();
            Arrays.stream(m.getParameters()).sorted(Comparator.comparing(Parameter::getName)).forEach(p -> out.println(p.getName() + ": " + p.getName() + ","));
            out.removeTab().println("},").println("success");
            out.removeTab().println(");");
            out.removeTab().println("},");
        });
        out.removeTab().println("};");
        this.writeRemainingTypes(out);
    }

    private void writeRemainingTypes(TabWriter out) {
        while (!this.toWrite.isEmpty()) {
            Class first = this.toWrite.poll();
            if (this.written.contains(first)) continue;
            this.writeInterface(first, out);
        }
    }

    public void generate(String sPackage, File target) throws IOException {
        this.generate(new Reflections(sPackage, new Scanner[0]), target);
    }

    public void generate(Reflections reflections, File target) throws FileNotFoundException, IOException {
        TabWriter out = new TabWriter(new PrintWriter(new OutputStreamWriter(new FileOutputStream(target))));
        out.println("import * as $ from \"jquery\";");
        this.toWrite.addAll(reflections.getTypesAnnotatedWith(ToTypescript.class));
        this.writeRemainingTypes(out);
        Set annotated = reflections.getTypesAnnotatedWith(Controller.class);
        annotated.addAll(reflections.getTypesAnnotatedWith(RestController.class));
        for (Class controller : annotated) {
            this.writeController(controller, out);
        }
        out.close();
    }

    public static void main(String[] args) throws IOException {
        new Generator().generate(args[0], new File(args[1]));
    }

    static {
        toTypescriptType.put(String.class, "string");
        toTypescriptType.put(Integer.class, "number");
        toTypescriptType.put(Integer.TYPE, "number");
        toTypescriptType.put(Double.class, "number");
        toTypescriptType.put(Double.TYPE, "number");
        toTypescriptType.put(Float.class, "number");
        toTypescriptType.put(Float.TYPE, "number");
        toTypescriptType.put(Short.class, "number");
        toTypescriptType.put(Short.TYPE, "number");
        toTypescriptType.put(Long.class, "number");
        toTypescriptType.put(Long.TYPE, "number");
        toTypescriptType.put(BigDecimal.class, "number");
        toTypescriptType.put(BigInteger.class, "number");
        toTypescriptType.put(Void.class, "void");
        toTypescriptType.put(Void.TYPE, "void");
        toTypescriptType.put(Boolean.class, "boolean");
        toTypescriptType.put(Boolean.TYPE, "boolean");
    }
}

