/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.lazysql;

import de.thomas_oster.lazysql.AbstractRDBMSAdapter;
import de.thomas_oster.lazysql.Argument;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class MysqlAdapter
extends AbstractRDBMSAdapter {
    public MysqlAdapter() {
        this.tryToLoadDriver("com.mysql.cj.jdbc.Driver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Argument> getSqlQueryType(Connection con, String sql, List<Argument> params) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        if (sql.contains(";")) {
            throw new AbstractRDBMSAdapter.NotSupportedException("LayzSQL cannot yet determine the result of this query");
        }
        String[] parts = sql.toLowerCase().split("\\)");
        String end = parts[parts.length - 1];
        if (end.contains("limit")) {
            throw new AbstractRDBMSAdapter.NotSupportedException("LayzSQL cannot yet determine the result of this query");
        }
        LinkedList<Argument> a = new LinkedList<Argument>();
        boolean ac = con.getAutoCommit();
        con.setAutoCommit(false);
        try {
            con.prepareStatement("DROP TEMPORARY TABLE IF EXISTS `temp`").execute();
            con.prepareStatement("CREATE TEMPORARY TABLE `temp` " + sql + " LIMIT 0; ").execute();
            try {
                PreparedStatement s = con.prepareStatement("DESCRIBE `temp`");
                s.execute();
                ResultSet r = s.getResultSet();
                while (r.next()) {
                    a.add(new Argument(r.getString("Field"), this.toJavaType(r.getString("Type"))));
                }
            }
            finally {
                con.prepareStatement("DROP TEMPORARY TABLE IF EXISTS `temp`").execute();
            }
        }
        finally {
            con.rollback();
            con.setAutoCommit(ac);
        }
        return a;
    }

    private Type toJavaType(String sqlType) throws SQLException {
        if (sqlType.startsWith("varchar") || sqlType.startsWith("nvarchar") || sqlType.endsWith("text") || sqlType.startsWith("json")) {
            return String.class;
        }
        if (sqlType.startsWith("double")) {
            return Double.class;
        }
        if (sqlType.startsWith("float")) {
            return Float.class;
        }
        if (sqlType.endsWith("int")) {
            return Integer.class;
        }
        if (sqlType.startsWith("decimal") || sqlType.startsWith("numeric")) {
            return BigDecimal.class;
        }
        if (sqlType.equals("xml")) {
            return String.class;
        }
        if (sqlType.equals("uniqueidentifier")) {
            return String.class;
        }
        if (sqlType.equals("date")) {
            return Date.class;
        }
        if (sqlType.equals("timestamp") || sqlType.equals("datetime")) {
            return Timestamp.class;
        }
        if (sqlType.startsWith("char")) {
            return String.class;
        }
        if (sqlType.equals("bit")) {
            return Boolean.class;
        }
        throw new SQLException("Unknown Type " + sqlType);
    }

    @Override
    public void checkSQLSyntax(Connection con, String sql, List<Argument> params) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        throw new AbstractRDBMSAdapter.NotSupportedException("MySQL Adapter cannot yet validate syntax");
    }
}

