/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.lazysql;

import de.thomas_oster.lazysql.AbstractRDBMSAdapter;
import de.thomas_oster.lazysql.Argument;
import de.thomas_oster.lazysql.ArgumentListCache;
import de.thomas_oster.lazysql.DbConfig;
import de.thomas_oster.lazysql.Lazy;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;

public class DbQueryTyper {
    private static final Map<DbConfig, DbCon> cache = new LinkedHashMap<DbConfig, DbCon>();
    private Lazy<Connection, AbstractRDBMSAdapter.NotSupportedException> db;
    private ArgumentListCache fileCache;
    private AbstractRDBMSAdapter rdbms;

    DbQueryTyper(DbConfig cfg, Messager messager) throws SQLException, DbConfig.ConfigException {
        if (cfg != null) {
            if (cache.containsKey(cfg)) {
                this.db = DbQueryTyper.cache.get((Object)cfg).con;
                this.fileCache = DbQueryTyper.cache.get((Object)cfg).cache;
                this.rdbms = DbQueryTyper.cache.get((Object)cfg).rdbms;
            } else {
                DriverManager.setLoginTimeout(5);
                Properties properties = new Properties();
                properties.put("connectTimeout", "2000");
                properties.put("user", cfg.dbuser);
                properties.put("password", cfg.dbpassword);
                String dburl = cfg.dburl;
                this.db = new Lazy(() -> {
                    try {
                        if (messager != null) {
                            messager.printMessage(Diagnostic.Kind.NOTE, "Connecting to DB " + cfg.dburl);
                        }
                        return DriverManager.getConnection(dburl, properties);
                    }
                    catch (SQLException ex) {
                        throw new AbstractRDBMSAdapter.NotSupportedException(ex.getLocalizedMessage());
                    }
                });
                this.fileCache = new ArgumentListCache(StringUtils.isEmpty((CharSequence)cfg.cachefile) ? null : new File(cfg.cachefile));
                this.rdbms = AbstractRDBMSAdapter.getAdapterByDbUri(dburl, cfg.customDriver);
                DbCon c = new DbCon();
                c.cache = this.fileCache;
                c.con = this.db;
                c.rdbms = this.rdbms;
                cache.put(cfg, c);
            }
        }
        if (this.db == null) {
            throw new SQLException("No Config found");
        }
    }

    public List<String> getTables(String prefix) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        return this.fileCache.getStrings("GET-TABLES " + prefix, () -> this.rdbms.getTables(this.db.get(), prefix));
    }

    public List<String> getTables(String catalog, String schema, String prefix) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        return this.fileCache.getStrings("GET-TABLES " + catalog + "#" + schema + "#" + prefix, () -> this.rdbms.getTables(this.db.get(), catalog, schema, prefix));
    }

    public List<String> getSchemas(String prefix) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        return this.fileCache.getStrings("GET-SCHEMAS " + prefix, () -> this.rdbms.getSchemas(this.db.get(), prefix));
    }

    public AbstractRDBMSAdapter.FullyQualifiedName getFqn(String name) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        return this.rdbms.getFqn(this.db.get(), name);
    }

    public List<Argument> getTableColumns(String name, String prefix) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        return this.fileCache.get(name + "#" + prefix, () -> this.rdbms.getTableColumns(this.db.get(), name, null));
    }

    public List<Argument> getInsertableTableColumns(String name, String prefix) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        return this.fileCache.get("insertable#" + name + "#" + prefix, () -> this.rdbms.getInsertableTableColumns(this.db.get(), name, null));
    }

    public List<AbstractRDBMSAdapter.Procedure> getStoredProcedures(String catalog, String schema, String prefix) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        return this.fileCache.getProcedures("GET-PROCEDURES " + catalog + "#" + schema + "#" + prefix, () -> this.rdbms.getStoredProcedures(this.db.get(), catalog, schema, prefix));
    }

    public List<AbstractRDBMSAdapter.Procedure> getStoredProcedures(String prefix) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        return this.fileCache.getProcedures("GET-PROCEDURES " + prefix, () -> this.rdbms.getStoredProcedures(this.db.get(), prefix));
    }

    public List<Argument> getStoredProcedureParameters(String name) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        return this.fileCache.get(name, () -> this.rdbms.getStoredProcedureParameters(this.db.get(), name));
    }

    public List<Argument> getSqlQueryType(String sql, List<Argument> params) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        return this.fileCache.get(sql + "#WITH#" + Argument.toArgumentList(params), () -> this.rdbms.getSqlQueryType(this.db.get(), sql, params));
    }

    void checkSQLSyntax(String sql, List<Argument> params) throws SQLException, AbstractRDBMSAdapter.NotSupportedException {
        this.fileCache.get(sql + "#WITH#" + Argument.toArgumentList(params), () -> {
            this.rdbms.checkSQLSyntax(this.db.get(), sql, params);
            return new LinkedList();
        });
    }

    private static class DbCon {
        public Lazy<Connection, AbstractRDBMSAdapter.NotSupportedException> con;
        public ArgumentListCache cache;
        public AbstractRDBMSAdapter rdbms;

        private DbCon() {
        }
    }
}

