/*
 * Decompiled with CFR 0.152.
 */
package de.thomas_oster.lazysql;

import de.thomas_oster.lazysql.AbstractRDBMSAdapter;
import de.thomas_oster.lazysql.Argument;
import de.thomas_oster.lazysql.DbQueryTyper;
import de.thomas_oster.lazysql.LazySQLProcessor;
import de.thomas_oster.lazysql.annotations.LazySQLInsert;
import de.thomas_oster.lazysql.annotations.LazySQLSelect;
import de.thomas_oster.lazysql.annotations.LazySQLStoredProcedure;
import de.thomas_oster.lazysql.annotations.LazySQLUpsert;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Completions;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.apache.commons.lang3.StringUtils;

public class AutoComplete {
    private static String getNonemptyMemberValue(AnnotationMirror annotation, String property) throws Exception {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> v : annotation.getElementValues().entrySet()) {
            if (!v.getKey().toString().startsWith(property)) continue;
            String result = v.getValue().toString();
            if (StringUtils.isEmpty((CharSequence)result)) break;
            return result;
        }
        throw new Exception("Member not found or empty");
    }

    /*
     * WARNING - void declaration
     */
    public static Iterable<? extends Completion> getCompletions(LazySQLProcessor p, Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        LinkedList<Completion> result = new LinkedList<Completion>();
        try {
            String table;
            DbQueryTyper db;
            Iterator<String> db2;
            if (LazySQLSelect.class.getName().equals(annotation.getAnnotationType().toString())) {
                String[] current;
                if ("returns".equals(member.getSimpleName().toString())) {
                    String query = AutoComplete.getNonemptyMemberValue(annotation, "value").replaceAll("\\{\"", "").replaceAll("\"\\}", "").replaceAll("\", \"", " ").replaceAll("\\\\'", "'").replace("{WHERE}", "WHERE 1 = 1").replaceAll(":", "@");
                    db2 = p.getDatabaseForElement(element, null, null);
                    String string = Argument.toArgumentList(((DbQueryTyper)((Object)db2)).getSqlQueryType(query, null));
                    result.add(Completions.of("\"" + string + "\"", "Returns Type from db"));
                }
                if ("value".equals(member.getSimpleName().toString()) && (current = userText.toLowerCase().replaceAll("\"", "").split(" ")).length > 2) {
                    String plast = current[current.length - 2];
                    String string = current[current.length - 1];
                    if ("from".equals(string) || "join".equals(string)) {
                        plast = string;
                        String string2 = "";
                    }
                    if ("from".equals(plast) || "join".equals(plast)) {
                        void var8_12;
                        DbQueryTyper dbQueryTyper = p.getDatabaseForElement(element, null, null);
                        for (String t : dbQueryTyper.getTables((String)var8_12)) {
                            String ut = userText.replaceAll("\"", "");
                            result.add(Completions.of("\"" + ut + t.substring(var8_12.length()) + "\"", "Tables from db"));
                        }
                    }
                }
            }
            if (LazySQLStoredProcedure.class.getName().equals(annotation.getAnnotationType().toString())) {
                if ("params".equals(member.getSimpleName().toString())) {
                    String procedure = AutoComplete.getNonemptyMemberValue(annotation, "value").replaceAll("\"", "");
                    DbQueryTyper db22 = p.getDatabaseForElement(element, null, null);
                    String string = Argument.toArgumentList(db22.getStoredProcedureParameters(procedure));
                    result.add(Completions.of("\"" + string + "\"", "Params from db"));
                }
                if ("value".equals(member.getSimpleName().toString())) {
                    db = p.getDatabaseForElement(element, null, null);
                    String text = userText.replaceAll("\"", "");
                    if (!text.contains(".")) {
                        for (AbstractRDBMSAdapter.Procedure procedure : db.getStoredProcedures(text)) {
                            result.add(Completions.of("\"" + procedure.getName() + "\"", procedure.getComment()));
                        }
                        for (String string : db.getSchemas(text)) {
                            result.add(Completions.of("\"" + string + ".", "Schema "));
                        }
                    } else {
                        AbstractRDBMSAdapter.FullyQualifiedName fullyQualifiedName = db.getFqn(text);
                        for (AbstractRDBMSAdapter.Procedure sp : db.getStoredProcedures(fullyQualifiedName.catalog, fullyQualifiedName.schema, fullyQualifiedName.name)) {
                            result.add(Completions.of("\"" + fullyQualifiedName.schema + "." + sp.getName() + "\"", sp.getComment()));
                        }
                    }
                }
            }
            if (LazySQLInsert.class.getName().equals(annotation.getAnnotationType().toString()) || LazySQLUpsert.class.getName().equals(annotation.getAnnotationType().toString())) {
                if ("params".equals(member.getSimpleName().toString())) {
                    table = AutoComplete.getNonemptyMemberValue(annotation, LazySQLInsert.class.getName().equals(annotation.getAnnotationType().toString()) ? "value" : "table").replaceAll("\"", "");
                    db2 = p.getDatabaseForElement(element, null, null);
                    String string = Argument.toArgumentList(((DbQueryTyper)((Object)db2)).getTableColumns(table, null));
                    result.add(Completions.of("\"" + string + "\"", "Table Columns from db"));
                }
                if ("value".equals(member.getSimpleName().toString()) || "table".equals(member.getSimpleName().toString())) {
                    db = p.getDatabaseForElement(element, null, null);
                    if (!(userText = userText.replaceAll("\"", "")).contains(".")) {
                        for (String string : db.getTables(userText)) {
                            result.add(Completions.of("\"" + string + "\"", "Tables from db"));
                        }
                        for (String string : db.getSchemas(userText)) {
                            result.add(Completions.of("\"" + string + ".", "Schema "));
                        }
                    } else {
                        AbstractRDBMSAdapter.FullyQualifiedName fqn = db.getFqn(userText);
                        for (String string : db.getTables(fqn.catalog, fqn.schema, fqn.name)) {
                            result.add(Completions.of("\"" + fqn.schema + "." + string + "\"", "Tables from db"));
                        }
                    }
                }
            }
            if (LazySQLUpsert.class.getName().equals(annotation.getAnnotationType().toString()) && "keys".equals(member.getSimpleName().toString())) {
                table = AutoComplete.getNonemptyMemberValue(annotation, "table").replaceAll("\"", "");
                db2 = p.getDatabaseForElement(element, null, null);
                String string = userText.replaceAll("\"", "");
                String[] stringArray = string.split(",");
                String last = stringArray[stringArray.length - 1].trim();
                for (Argument column : ((DbQueryTyper)((Object)db2)).getTableColumns(table, last)) {
                    if (!column.getName().toLowerCase().startsWith(last.toLowerCase())) continue;
                    result.add(Completions.of("\"" + string + column.getName().replace(last, "") + "\"", "Columns from DB"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

